// Author: Hannes Pabst

#ifndef ARRAY_H
#define ARRAY_H

#include <assert.h>

template<typename T, int size>
class Array
{
public:
	static int const SIZE = size;

	typedef T Elem;

	T &operator[](int idx);
	T const &operator[](int idx) const;

// private:
	T elems[size];
};

template<typename T>
class ArrayRef
{
public:
	typedef T Elem;

	ArrayRef();
	ArrayRef(T *elems, int size);
	template<int arraySize>
	ArrayRef(T (&elems)[arraySize]);
	template<typename U, int arraySize>
	ArrayRef(Array<U, arraySize> &array);
	template<typename U, int arraySize>
	ArrayRef(Array<U, arraySize> const &array);

	T &operator[](int idx);
	T const &operator[](int idx) const;

	int getSize() const;

private:
	T *elems;
	int size;
};

template<typename T, int size>
T &Array<T, size>::operator[](int const idx)
{
	return const_cast<T &>(const_cast<Array<T, size> const &>(*this)[idx]);
}

template<typename T, int size>
T const &Array<T, size>::operator[](int const idx) const
{
	assert(idx >= 0 && idx < size);
	return elems[idx];
}

template<typename T>
ArrayRef<T>::ArrayRef()
: elems(0)
, size(0)
{
}

template<typename T>
ArrayRef<T>::ArrayRef(T * const elems, int const size)
: elems(elems)
, size(size)
{
}

template<typename T>
template<int arraySize>
ArrayRef<T>::ArrayRef(T (&elems)[arraySize])
: elems(elems)
, size(arraySize)
{
}

template<typename T>
template<typename U, int arraySize>
ArrayRef<T>::ArrayRef(Array<U, arraySize> &array)
: elems(&array[0])
, size(arraySize)
{
}

template<typename T>
template<typename U, int arraySize>
ArrayRef<T>::ArrayRef(Array<U, arraySize> const &array)
: elems(&array[0])
, size(arraySize)
{
}

template<typename T>
T &ArrayRef<T>::operator[](int const idx)
{
	return const_cast<T &>(const_cast<ArrayRef<T> const &>(*this)[idx]);
}

template<typename T>
T const &ArrayRef<T>::operator[](int const idx) const
{
	assert(idx >= 0 && idx < size);
	return elems[idx];
}

template<typename T>
int ArrayRef<T>::getSize() const
{
	return size;
}

#endif
