// Author: Hannes Pabst

#ifndef AI_TESTER_H
#define AI_TESTER_H

#include "simple_tile.h"
#include "field.h"
#include "field_info.h"
#include "hp_evaluator_scores.h"
#include "field_histograms.h"
#include "block_histograms.h"

class AiTester
{
public:
	typedef ::Field<SimpleTile, 10, 20> Field;
	typedef ::FieldInfo<Field> FieldInfo;
	typedef ::FieldHistograms<Field> FieldHistograms;
	typedef HpEvaluatorScores<Field> EvaluatorScores;

	AiTester(EvaluatorScores const &evaluatorScores, int currentBlock);

	bool putBlock(int nextBlock);

	Field const &getField() const;
	FieldInfo const &getFieldInfo() const;
	FieldHistograms const &getFieldHistograms() const;
	BlockHistograms const &getBlockHistograms() const;

private:
	EvaluatorScores const *evaluatorScores;
	Field field;
	FieldInfo fieldInfo;
	FieldHistograms fieldHistograms;
	BlockHistograms blockHistograms;
	int currentBlock;
};


inline AiTester::Field const &AiTester::getField() const
{
	return field;
}

inline AiTester::FieldInfo const &AiTester::getFieldInfo() const
{
	return fieldInfo;
}

inline AiTester::FieldHistograms const &AiTester::getFieldHistograms() const
{
	return fieldHistograms;
}

inline BlockHistograms const &AiTester::getBlockHistograms() const
{
	return blockHistograms;
}

#endif
