// Author: Hannes Pabst

#include "ai_tester.h"
#include "ai_piece.h"

AiTester::AiTester(EvaluatorScores const &evaluatorScores, int const currentBlock)
: evaluatorScores(&evaluatorScores)
, currentBlock(currentBlock)
{
}

bool AiTester::putBlock(int const nextBlock)
{
	Piece const aiPiece = calculateAiPiece(*evaluatorScores, field, fieldInfo, currentBlock, nextBlock);
	if (canPutPiece(field, aiPiece))
	{
		putPiece(field, aiPiece);
		int clearedLines = 0;
		for (int tile = 0; tile < Block::TILE_NUM; ++tile)
		{
			Point const tilePosition = getTilePosition(aiPiece, tile);
			fieldInfo.putTile(tilePosition.x, tilePosition.y);
			if (fieldInfo.getTileNum(tilePosition.y) == Field::WIDTH)
			{
				clearFullLine(field, fieldInfo, tilePosition.y);
				++clearedLines;
			}
		}
		fieldHistograms.addField(fieldInfo);
		blockHistograms.addBlock(currentBlock, clearedLines);
		currentBlock = nextBlock;
		return true;
	}
	return false;
}
