// Author: Hannes Pabst

#ifndef AI_PIECE_H
#define AI_PIECE_H

#include "field_transition.h"
#include "piece_field.h"
#include "evaluator.h"

template <typename Field>
int stackBlock(FieldInfo<Field> const &fieldInfo, int x, int block);

template <typename Field>
Piece calculateAiPiece(EvaluatorScores<Field> const &evaluatorScores, Field &field, FieldInfo<Field> const &fieldInfo, int currentBlock, int nextBlock);


template <typename Field>
__forceinline int stackBlock(FieldInfo<Field> const &fieldInfo, int const x, int const block)
{
	int minY = Field::HEIGHT - 1;
	for (int tile = 0; tile < Block::TILE_NUM; ++tile)
	{
		Point const tilePosition = Block::getTilePosition(block, tile);
		int const y = fieldInfo.getTopTileY(x + tilePosition.x) - tilePosition.y;
		if (y < minY)
			minY = y;
	}
	return minY - 1;
}

template <typename Field>
__forceinline Piece calculateAiPiece(EvaluatorScores<Field> const &evaluatorScores, Field &field, FieldInfo<Field> const &fieldInfo, int const currentBlock, int const nextBlock)
{
	Piece bestPiece(currentBlock, Point(0, 0));
	Evaluator<Field> evaluator(evaluatorScores);
	int block = currentBlock;
	do
	{
		for (int x = blockLeft(block); x <= blockRight<Field>(block); ++x)
		{
			int const y = stackBlock(fieldInfo, x, block);
			if (y >= 0)
			{
				Piece const piece0(block, Point(x, y));
				FieldTransition<Field> fieldTransition0(field, fieldInfo);
				fieldTransition0.putPiece(piece0);
				if (fieldTransition0.willUseField())
					putPiece(field, piece0);
				int block = nextBlock;
				do
				{
					for (int x = blockLeft(block); x <= blockRight<Field>(block); ++x)
					{
						int const y = stackBlock(fieldTransition0.getFieldInfo(), x, block);
						if (y >= 0)
						{
							Piece const piece1(block, Point(x, y));
							FieldTransition<Field> fieldTransition1 = fieldTransition0;
							fieldTransition1.putPiece(piece1);
							if (evaluator.evaluate(fieldTransition1))
								bestPiece = piece0;
						}
					}
					block = Block::rotate(block);
				}
				while (block != nextBlock);
				if (fieldTransition0.willUseField())
					removePiece(field, piece0);
			}
		}
		block = Block::rotate(block);
	}
	while (block != currentBlock);
	return bestPiece;
}

#endif
