#ifndef __CBOMBMAP_H__
#define __CBOMBMAP_H__

#include <vector>

bool out_of_range(int x, int y, int w, int h);

class CBombMap
{
    private:
        int w,h,a_bomb;
        std::vector<int> visible;
        std::vector<bool> bomb_map;
        void activateLocation(int x, int y);
    public:
        CBombMap(int w, int h) : visible(w*h,UNKNOWN),bomb_map(w*h,0) {this->w = w; this->h = h;};
        CBombMap() {w=0; h=0;};
        bool setRandomBombMap(int a_bombs); //returns true on success
        int getTileValue(int x, int y) {/*if(!out_of_range(x,y,w,h))*/ return visible[x+y*w]; return -3;};
        std::vector<int> getVisibleMap() {return visible;};
        bool checkBomb(int x, int y) {/*if(!out_of_range(x,y,w,h))*/ {return bomb_map.at(x+y*w);} return 0;};
        void flag(int x, int y)
        {
            //if(!out_of_range(x,y,w,h))
            {
                if(visible[x+y*w]<0) visible[x+y*w] = (visible.at(x+y*w)==UNKNOWN)?FLAGGED:UNKNOWN;
            }
        }; //(de)flags a tile
        bool dropScout(int x, int y); //returns true when stepped on a bomb
        int getW() {return w;};
        int getH() {return h;};
        int getBombCount() {return a_bomb;};
        bool checkWin();
        void reset();
};
#endif
