#include <allegro5/allegro5.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <cstdio>
#include "macros.h"
#include "bombmap.h"
#include "GUI_system.h"
#include "CRenderer.h"


void CRectangle::draw(ALLEGRO_COLOR color)
{
    al_draw_filled_rectangle(x,y,x+w,y+h,color);
    al_draw_rectangle(x,y,x+w,y+h,al_map_rgb(0,0,0),1);
}

int CRenderer::getBoardX(int mouse_x)
{
    if(mouse_x<playing_field.x || mouse_x>playing_field.x+playing_field.w) return -1;
    return (mouse_x-playing_field.x)*field->getW()/playing_field.w;
}

int CRenderer::getBoardY(int mouse_y)
{
    if(mouse_y<playing_field.y || mouse_y>playing_field.y+playing_field.h) return -1;
    return (mouse_y-playing_field.y)*field->getW()/playing_field.w;
}

void CRenderer::render(GameState state)
{
    if(resized)
    {
        al_acknowledge_resize(al_get_current_display());
        resized = false;
        reset_coordinates();
    }
    al_clear_to_color(c_back);
    top_bar.draw(c_back);
    game_screen.draw(c_back);
    playing_field.draw(c_back);
    reset_button.draw(c_tile_unknown);
    al_draw_text(font,c_text,reset_button.x+reset_button.w/2,reset_button.y+reset_button.w/2-al_get_font_line_height(font)/2,ALLEGRO_ALIGN_CENTRE,"Reset");

    //Field
    float field_height = (float)field->getH();
    float field_width = (float)field->getW();
    int bombs_left = field->getBombCount();
    for(int y=0;y<(int)field_height;y++)
    {
        for(int x=0;x<(int)field_width;x++)
        {
            float r1x,r1y,r2x,r2y;
            ALLEGRO_COLOR rect_color;
            char tile_text[2]= " ";

            float tile_dimension = (float)playing_field.w/field_width;

            r1x = (float)playing_field.x+(float)x*tile_dimension;
            r1y = (float)playing_field.y+(float)y*tile_dimension;
            r2x = r1x+tile_dimension;
            r2y = r1y+tile_dimension;
            int tile_value = field->getTileValue(x,y);
            if(tile_value>=0)
            {
                rect_color=c_tile_known;
                if(tile_value!=0) tile_text[0] = tile_value+48;
            } else
            {
                rect_color = c_tile_unknown;
                if(state==STATE_DEAD)
                {
                    if(tile_value==-2)
                    {
                        if(field->checkBomb(x,y)) tile_text[0] = 'F';
                        else tile_text[0] = '/';
                    } else if(field->checkBomb(x,y)) tile_text[0] = '*';
                }
                else if(tile_value==-2) {tile_text[0] = 'F'; bombs_left--;}
            }
            al_draw_filled_rectangle(r1x,r1y,r2x,r2y,rect_color);
            al_draw_rectangle(r1x,r1y,r2x,r2y,al_map_rgb(0,0,0),1);
            al_draw_text(numbers_font,c_numbers,
                         (float)playing_field.x+((float)x+0.5f)*(float)playing_field.w/field_width,
                         (float)playing_field.y+(float)y*(float)playing_field.h/field_height,ALLEGRO_ALIGN_CENTRE,tile_text);
        }
    }
    //status text
    char win_text[16];
    if(state==STATE_WON) sprintf(win_text,"You won!");
    else if(state==STATE_DEAD) sprintf(win_text,"You lost!");
    else sprintf(win_text,"bombs left: %i",bombs_left);
    al_draw_text(font,c_text,
                        (float)(reset_button.x-top_bar.x)/2.0f - (float)al_get_text_width(font,win_text)/2.0f,
                        (float)(top_bar.y+top_bar.h/2-al_get_font_line_height(font)/2),
                        ALLEGRO_ALIGN_CENTRE,win_text);

    al_flip_display();
}

void CRenderer::reset_coordinates()
{
    int scr_width = al_get_display_width(al_get_current_display());
    int scr_height = al_get_display_height(al_get_current_display());

    top_bar.w = scr_width;
    top_bar.h = scr_height/10;
    top_bar.x = 0;
    top_bar.y = 0;

    reset_button.h = top_bar.h-4;
    if(reset_button.h<al_get_font_line_height(font))
    {
        al_destroy_font(font);
        font = al_load_font(fontfilename,reset_button.h,0);
    }
    reset_button.w = al_get_text_width(font,"Reset")+4;
    reset_button.x = top_bar.w/2+top_bar.x-reset_button.w/2;
    reset_button.y = top_bar.y+2;

    game_screen.w = scr_width;
    game_screen.h = scr_height - top_bar.h;
    game_screen.x = 0;
    game_screen.y = top_bar.h;

    playing_field.w = game_screen.w - 4;
    playing_field.h = game_screen.h - 4;
    playing_field.x = game_screen.x + 2;
    playing_field.y = game_screen.y + 2;

    float tile_dimension; //stores the width/height of each square

    if((float)field->getW()/(float)field->getH() < (float)game_screen.w/(float)game_screen.h) //board is too high to fit on-screen
    {
        tile_dimension = (float)playing_field.h/(float)field->getH();
        playing_field.w = (int)(tile_dimension*(float)field->getW());
        playing_field.x = game_screen.x + game_screen.w/2 - playing_field.w/2;
    }
    else
    {
        tile_dimension = (float)playing_field.w/(float)field->getW();
        playing_field.h = (int)(tile_dimension*(float)field->getH());
        playing_field.y = game_screen.y + game_screen.h/2 - playing_field.h/2;
    }

        al_destroy_font(numbers_font);
        numbers_font = al_load_font(fontfilename,(int)tile_dimension,0);
}

