#ifndef __CRENDERER_H__
#define __CRENDERER_H__

class CRenderer
{
    private:
        ALLEGRO_COLOR c_tile_unknown,c_tile_known,c_text,c_numbers,c_back;
        CRectangle top_bar,reset_button,game_screen,playing_field;
        CBombMap* field;
        ALLEGRO_FONT* font;
        ALLEGRO_FONT* numbers_font;
        const char* fontfilename;
        void reset_coordinates();
    public:
        bool resized;
        CRenderer() : c_tile_unknown(al_map_rgb(0,0x33,0x33)),c_tile_known(al_map_rgb(0,0xbb,0xbb)),c_text(al_map_rgb(0,0,0)),c_numbers(al_map_rgb(0,0,0)),c_back(al_map_rgb(0,0x66,0x66)),resized(false) {reset_coordinates();};
        CRenderer(const char* font,CBombMap* map):c_tile_unknown(al_map_rgb(0,0x33,0x33)),c_tile_known(al_map_rgb(0,0xbb,0xbb)),c_text(al_map_rgb(0,0,0)),c_numbers(al_map_rgb(0,0,0)),c_back(al_map_rgb(0,0x66,0x66)),field(map),fontfilename(font),resized(false) {this->font = al_load_font(fontfilename,20,0); this->numbers_font = al_load_font(fontfilename,10,0); reset_coordinates();};
        //CRenderer(ALLEGRO_COLOR text_color,ALLEGRO_COLOR number_color,ALLEGRO_COLOR background,ALLEGRO_COLOR unknown_tile,ALLEGRO_COLOR known_tile) : ;
        void render(GameState state);
        bool getResetButton(int mouse_x,int mouse_y) {return reset_button.mouse_over(mouse_x,mouse_y);};
        int getBoardX(int mouse_x);
        int getBoardY(int mouse_y);
};
#endif
