#include <allegro5/allegro5.h>
//#include <allegro5/allegro_image.h>
#include <allegro5/allegro_primitives.h>
//#include <allegro5/allegro_color.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
//#include <allegro5/allegro_audio.h>
//#include <allegro5/allegro_acodec.h>
//#include <allegro5/allegro_memfile.h>
//#include <allegro5/allegro_physfs.h>
//#include <allegro5/allegro_native_dialog.h>

#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <time.h>
#include "macros.h"
#include "bombmap.h"
#include "GUI_system.h"
#include "CRenderer.h"
#include "CGame.h"

void init(ALLEGRO_EVENT_QUEUE* &e_queue, int w, int h)
{
	al_set_new_display_flags(ALLEGRO_OPENGL);
	al_set_new_display_flags(ALLEGRO_WINDOWED|ALLEGRO_RESIZABLE);

	ALLEGRO_DISPLAY* display = al_create_display(w,h); //it doesn't need to be global because you can always access it by al_get_current_display();
	if(!display) printf("ERROR INITIALIZING THE DISPLAY AT %i %i!",w,h);

	e_queue = al_create_event_queue();
	if(!e_queue) printf("ERROR CREATING EVENT QUEUE!");

	al_register_event_source(e_queue, al_get_display_event_source(display));
	al_register_event_source(e_queue, al_get_mouse_event_source());
	al_register_event_source(e_queue, al_get_keyboard_event_source());
	//al_register_event_source(e_queue, al_get_joystick_event_source());
}

int install_allegro()
{
	if(!al_init())
	{
		printf("ERROR INITIALIZING ALLEGRO!");
		return 0;
	}
	if(!al_install_keyboard())
	{
		printf("ERROR INITIALIZING KEYBOARD!");
		return 0;
	}

	if(!al_install_mouse())
	{
		printf("ERROR INITIALIZING MOUSE!");
		return 0;
	}
	/*if(!al_install_joystick())
	{
	    printf("ERROR INITIALIZING JOYSTICK!");
	    return 0;
	}
	if(!al_init_image_addon())
	{
		printf("ERROR INITIALIZING IMAGE ENGINE!");
		return 0;
	}
	*/if(!al_init_primitives_addon())
	{
		printf("ERROR INITIALIZING PRIMITIVES ADDON!");
	}
	/**/
	al_init_font_addon();
	if(!al_init_ttf_addon())
	{
		printf("ERROR INITIALIZING FONT ENGINE!");
		return 0;
	}
	/*
	if(!al_init_audio_addon())
	{
	    printf("ERROR INITIALIZING AUDIO ADDON!");
	    return 0;
	}
	if(!al_init_acodec_addon())
	{
	    printf("ERROR INITIALIZING AUDIO CODECS!");
	    return 0;
	}*/
	//al_set_physfs_file_interface();
	return 1;
}

int main()
{
    srand(time(NULL));
    ALLEGRO_EVENT_QUEUE* event_queue = NULL;
    if(!install_allegro()) return 1;

    /*ALPHA console code*/
    int w,h,a_bombs;
    std::cout << "Welcome to Minebattle alpha 1.1" << std::endl;
    std::cout << "How wide and high do you want the board to be? Please use this syntax:" << std::endl;
    std::cout <<"[width] [height]"<<std::endl <<"and replace [width] and [height] with the desired values."<<std::endl;
    std::cin >> w >> h;
    std::cout << "How many bombs do you want to have placed?(maximum is "<<w*h << ")" << std::endl;
    std::cin >> a_bombs;
    /*End alpha console code*/

    init(event_queue,800,600);
    al_set_window_title(al_get_current_display(),"Battlemines alpha 1.0");
    ALLEGRO_TIMER* timer = al_create_timer(1.0/60.0);
    al_register_event_source(event_queue,al_get_timer_event_source(timer));
    CGame game(w,h,a_bombs,"times.ttf");

    /*ALLEGRO_FONT* font_times = al_load_font("times.ttf",20,0);
    if(font_times==NULL)
    {
        printf("ERROR LOADING FONT!");
        return -1;
    }

    al_clear_to_color(al_map_rgb(0,0,0));
    al_draw_text(font_times,al_map_rgb(255,255,0),400,300,ALLEGRO_ALIGN_CENTRE,"Hello World");*/

    bool redraw = true;

    ALLEGRO_EVENT ev;
    bool quit = false;
    al_start_timer(timer);
    while(!quit)
    {
        al_wait_for_event(event_queue,&ev);
        if((ev.type==ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode==ALLEGRO_KEY_ESCAPE) || ev.type==ALLEGRO_EVENT_DISPLAY_CLOSE) quit = true;
        else if(ev.type==ALLEGRO_EVENT_TIMER) redraw = true;
        else game.ProcessEvent(ev);
        if(redraw && al_is_event_queue_empty(event_queue)) {game.render(); redraw = false;}
    }

    al_destroy_display(al_get_current_display());
	al_destroy_event_queue(event_queue);
    return 0;
}

