#include <allegro5/allegro5.h>
#include <allegro5/allegro_font.h>
#include "macros.h"
#include "bombmap.h"
#include "GUI_system.h"
#include "CRenderer.h"
#include "CGame.h"

void CGame::ProcessEvent(ALLEGRO_EVENT ev)
{
    if(ev.type==ALLEGRO_EVENT_MOUSE_BUTTON_UP)
    {
        if(renderer.getResetButton(ev.mouse.x,ev.mouse.y)) reset();
        else if(state==STATE_PLAYING)
        {
            int x = renderer.getBoardX(ev.mouse.x);
            int y = renderer.getBoardY(ev.mouse.y);
            if(ev.mouse.button==1)
            {
                if(bombmap.dropScout(x,y)) state = STATE_DEAD;
                else if(bombmap.checkWin()) state = STATE_WON;
            } else if(ev.mouse.button==2) bombmap.flag(x,y);
        }
    }
    else if(ev.type==ALLEGRO_EVENT_DISPLAY_RESIZE) renderer.resized = true;
    else if(ev.type==ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode==ALLEGRO_KEY_R) reset();
};

void CGame::reset()
{
    bombmap.reset();
    state = STATE_PLAYING;
};
