#include <cstdlib>
#include "macros.h"
#include "bombmap.h"

bool out_of_range(int x, int y, int w, int h) {return (x<0 || y<0 || x>=w || y>=h);};

bool CBombMap::checkWin()
{
    for(int x=0;x<w;x++)
        for(int y=0;y<h;y++)
            if(visible.at(x+y*w)==UNKNOWN || (visible.at(x+y*w)==FLAGGED && !bomb_map.at(x+y*w))) return 0;
    return 1;
};

bool CBombMap::dropScout(int x, int y)
{
    if(checkBomb(x,y) && visible.at(x+y*w)!=FLAGGED) return 1; //dropped on a bomb
    activateLocation(x,y);
    return 0;
};

void CBombMap::activateLocation(int x, int y)
{
    if(out_of_range(x,y,w,h)) return;
    if(visible.at(x+y*w)!=UNKNOWN) return;
    //count the amount of bombs in the neighbourhood
    int abombs = 0;
    for(int cx = x-1; cx <= x+1; cx++)
    {
        for(int cy = y-1; cy <= y+1; cy++) {if(!out_of_range(cx,cy,w,h)) {abombs += (int)checkBomb(cx,cy);}}
    }
    visible.at(x+y*w) = abombs;
    if(!abombs)
    {
        for(int cx = x-1; cx <= x+1; cx++)
        {
            for(int cy = y-1; cy <= y+1; cy++) {if(!out_of_range(cx,cy,w,h)) {activateLocation(cx,cy);}}
        }
    }
};

bool CBombMap::setRandomBombMap(int a_bombs)
{
    if(a_bombs>w*h) return false; //check to make sure it won't get stuck in an infinite loop
    bomb_map.clear();
    bomb_map.resize(w*h,0);
    a_bomb=a_bombs;
    for(int i=0;i<a_bombs;i++)
    {
        bool placed = false;
        while(!placed)
        {
            int location = rand()%bomb_map.size();
            if(!bomb_map.at(location))
            {
                bomb_map.at(location) = true;
                placed = true;
            }
        }
    }
    return true;
};

void CBombMap::reset()
{
    setRandomBombMap(a_bomb);
    visible.clear();
    visible.resize(w*h,-1);
};

