#include <stdlib.h>
#include "sheep2.h"



unsigned char new_pipeline_block(void)
{
	unsigned char r = (rand() >> 8) & 7;
	return r & 4 ? BLOCK_SLOPE(r - 4) : BLOCK_FULL;
}



static void drop_column(BLOCK *first, BLOCK *last, float base)
{
	BLOCK *block;

	first->zv -= 0.007f;
	first->z += first->zv;
	for (block = first; block != last; block = block->nextdown) {
		block->nextdown->zv = block->zv;
		block->nextdown->z = block->z - 1.0f;
	}

	if (last->z < base) {
		float d = base - last->z;
		last->z = base;
		last->zv = 0.0f;
		for (block = first; block != last; block = block->nextdown) {
			block->z += d;
			block->zv = 0.0f;
		}
		// Make a nice loud boom sound?
	}
}



void update_blocks(STATE *state)
{
	int x, y;

	for (y = 0; y < state->l->h; y++) {
		for (x = 0; x < state->l->w; x++) {
			BLOCK *first = state->block[y][x];
			if (first) {
				BLOCK *last = first;
				for (;;) {
					if (!last->nextdown) {
						if (last->z >= BLOCK_RAISED)
							drop_column(first, last, 0.0f);
						break;
					}
					if (last->z >= last->nextdown->z + BLOCKS_SEPARATED) {
						drop_column(first, last, last->nextdown->z + 1.0f);
						last = first = last->nextdown;
					} else
						last = last->nextdown;
				}
			}
		}
	}
}
