#ifndef Weapon_h
#define Weapon_h

#include "../Game.h"
#include "../Vehicle.h"

#include "WeaponTypes.h"

#include <math.h>

class Vehicle;
class Game;

//abstract
class Weapon
{
public:
    Weapon(Game* game, Vehicle* owner, WEAPON_TYPE type);
    virtual ~Weapon() {}

    WEAPON_TYPE GetType() { return _type; }

    Vehicle* GetOwner() { return _owner; }
    void SetOwner(Vehicle* owner) { _owner = owner; }

    Vehicle* GetTarget() { return _target; }
    void SetTarget(Vehicle* target) { _target = target; }

    int GetTimeLeft() { return _timeLeft; }
    void SetTimeLeft(int timeLeft) { _timeLeft = timeLeft; }

    double GetX() { return _pos.x; }
    double GetY() { return _pos.y; }
    void SetX(double x) { _pos.x = x; }
    void SetY(double y) { _pos.y = y; }
    void SetPos(double x, double y) { _pos.x = x; _pos.y = y; }

    double GetW();
    double GetH();

    virtual void Activate();

    virtual void Tick() {};
    virtual void Draw() {};

protected:
    void ChooseTarget();
    void CountTimeAndFinalize();
    void SetAffectTimeInSeconds(short sec);

    Game* _game;
    Vehicle* _owner;
    Vehicle* _target;

    int _timeLeft;

    WEAPON_TYPE _type;

    Vector2D _pos;
};
#endif
