#include "Weapon.h"
#include "../Vehicle.h"

Weapon::Weapon(Game* game, Vehicle *owner, WEAPON_TYPE type) {
    _target = NULL;

    _game = game;
    _owner = owner;

    _type = type;

    _timeLeft = 0;
}

void Weapon::Activate() {
    _game->GetArena()->AddActiveWeapon(this);
    const float pan = _game->GetArena()->GetPan(_target != NULL ? _target->GetX() : _owner->GetX());
    _game->PlayWeaponSound(_type, pan);
}

void Weapon::ChooseTarget() {
    short livingVehicles = _game->CountLivingVehicles() - 1;

    if (livingVehicles >= 1) {
        short r = rand() % livingVehicles;

        short j = -1;
        for (short i = 0; i < MAX_PLAYERS_COUNT; i++) {
            Player* p = _game->GetPlayer(i);

            if (p != NULL && p->GetVehicle() != _owner) {
                if (p->GetVehicle()->GetState() == Vehicle::STATE_LIVING && p->IsEnabled() == true) {
                    j++;
                }
            }

            if (r == j) {
                _target = p->GetVehicle();
                break;
            }
        }
    }
}

void Weapon::CountTimeAndFinalize() {
    if (_timeLeft > 0) {
        _timeLeft--;
    } else {
        _game->GetArena()->RemoveActiveWeapon(this);
        delete this;
    }
}

void Weapon::SetAffectTimeInSeconds(short sec) {
    _timeLeft = sec * _game->GetTicksPerSecond();
}

double Weapon::GetW() {
    return _game->GetWeaponIconW(_type);
}

double Weapon::GetH() {
    return _game->GetWeaponIconH(_type);
}
