#ifndef Shive_h
#define Shive_h

#include "Particle.h"

class Shive : public Particle {
public:

    Shive(Game* game, const Vector2D &pos, double directionAngle, double speed, int radius, int color) : Particle(game, pos, directionAngle, speed, radius, color) {
        _dead = false;
    }

    virtual ~Shive() {
    }

    bool IsDead() { return _dead; }

    virtual void Tick() {
        if (_dead) {
            return;
        }

        _game->GetArena()->ClearCircle(_pos, _radius, true);

        Particle::Tick();

        _game->GetArena()->PlaceCircle(_pos, _radius, _color, true);

        if (_pos.x < 0 - _radius || _pos.x > _game->GetArena()->GetW() + _radius ||
                _pos.y < 0 - _radius || _pos.y > _game->GetArena()->GetH() + _radius) {
            _game->GetArena()->ClearCircle(_pos, _radius, true);
            _game->PlaySound(Game::SOUND_BORDER, _game->GetArena()->GetPan(_pos.x));
            _dead = true;
        }
    }

    virtual void Draw() {
        if (_dead) {
            return;
        }
    }

protected:
    bool _dead;
};

#endif //Shive_h
