#ifndef BombWeapon_h
#define BombWeapon_h

#include "../Weapon.h"

class BombWeapon : public Weapon {
public:

    BombWeapon(Game* game, Vehicle *owner, WEAPON_TYPE type) : Weapon(game, owner, type) {
        _currentExplosionRadius = 2;
    }

    virtual ~BombWeapon() {
    }

    virtual void Activate() {
        Weapon::Activate();

        _startPos = _owner->GetPos();
    }

    virtual void Tick() {
        if (_currentExplosionRadius <= _maxExplosionRadius) {
            _game->GetArena()->ClearCircle(_startPos, _currentExplosionRadius, true);
            _currentExplosionRadius += (short) _game->GetNormalSpeed()*2;
        } else {
            CountTimeAndFinalize();
        }
    }

    virtual void Draw() {
        for (int i = 0; i <= _visualShockThickness; i++) {
            _game->GetArena()->DrawCircle(_startPos, _currentExplosionRadius - i, _owner->GetColor(), false);
        }
    }

private:

    const static short _visualShockThickness = 5;
    const static short _maxExplosionRadius = 60;
    short _currentExplosionRadius;
    Vector2D _startPos;
};

#endif
