#ifndef Vehicle_h
#define	Vehicle_h

#include "Game.h"
#include "Player.h"
#include "Inventory.h"
#include "Weapons/WeaponTypes.h"
#define PI 3.1415926535897932384626433832795028841968

class Game;
class Player;
class Inventory;

class Vehicle {
public:
    enum STATE {
        STATE_LIVING,
        STATE_DYING,
        STATE_DEAD
    };
    
    Vehicle(Game* game, Player* owner);
    virtual ~Vehicle();

    Player* GetOwner() { return _owner; }
    Inventory* GetInventory() { return _inventory; }

    void TurnLeft();
    void TurnRight();
    void ActivateItem();
    void SelectNextItem();

    STATE GetState() { return _state; }

    const Vector2D& GetPos() { return _pos; }
    double GetX() { return _pos.x; }
    double GetY() { return _pos.y; }
    void SetPos(const Vector2D &pos) { _pos = pos; }
    void SetX(int x) { _pos.x = x; }
    void SetY(int y) { _pos.y = y; }

    double GetAngle() { return _angle; }
    void SetAngle(double angle) { _angle = angle; }

    int GetColor();

    void Die();
    void Reset();

    void Draw();
    void Tick();

    static int GetAngleCount() { return _angleCount; }
    
protected:
    void Move();
    void PickupWeapons();

protected:
    Game* _game;
    Player* _owner;
    Inventory* _inventory;
    const static short _angleCount = 12; //how many times a vehicle must turn left or right to move in the original direction again
    STATE _state;
    Vector2D _pos;
    double _angle; //moving direction
    bool _affectedBy[AFFECTING_WEAPON_TYPES_COUNT]; //affaction by each weapon (only affecting weapons)
};

#endif	/* Vehicle_h */
