#ifndef Player_h
#define Player_h

#include "PlayerTypes.h"
#include "Game.h"
#include "Vehicle.h"

class Game;
class Vehicle;

class Player {
public:

    Player(Game* game, int idNumber);
    virtual ~Player();

    PLAYER_TYPE GetType();

    short int GetTotalScore() { return _totalScore; }
    short int GetRoundScore() { return _roundScore; }
    void ApplyRoundScore(short _score);

    int GetIDNumber() { return _idNumber; }
    bool IsEnabled();
    short GetKeyForCommand(PLAYER_COMMAND command);
    int GetColor();

    Vehicle* GetVehicle() { return _vehicle; }

    void Reset();

    void Tick();
    void Draw();

    static const char* GetPlayerTypeString(PLAYER_TYPE playerType);

protected:
    void FollowCommands();
    void ComputeCommands();

    virtual bool GetsKeyImpulseForCommand(PLAYER_COMMAND command) = 0;

protected:
    Game* _game; //pointer to the game instance (main logic)
    Vehicle* _vehicle;
    int _idNumber;

    short _roundScore; //score for current round
    short _totalScore; //score for all rounds together
    short _aiCommandTimeCounter; //time to wait for next command

    bool _holdingKeyForCommand[PLAYER_COMMANDS_COUNT]; //state of each command-key
};

class AllegroPlayer : public Player {
public:
    AllegroPlayer(Game* game, short playerNumber) : Player(game, playerNumber) {};
    virtual ~AllegroPlayer() {};

protected:
    virtual bool GetsKeyImpulseForCommand(PLAYER_COMMAND command);
};

#endif
