#ifndef LMENU_ITEM_H
#define LMENU_ITEM_H

#include "menu.h"

namespace lmenu
{
    class Menu;

    class Item
    {
    public:

        Item() {}
        Item(Menu* parent, int posX = 0, int posY = 0);
        Item(Menu* parent, const char* text, int posX = 0, int posY = 0);

        virtual ~Item();

        void		Init();

        bool		HasBorderLine() { return _borderLine; }
        void		SetBorderLine(bool borderLine) { _borderLine = borderLine; }

        int		GetBorderLineColor() { return _borderLineColor; }
        void		SetBorderLineColor(int red, int green, int blue) { _borderLineColor = makecol(red, green, blue); SetBorderLine(true); }
        void		SetBorderLineColor(int borderLineColor) { _borderLineColor = borderLineColor; SetBorderLine(true); }

        bool		HasBackground() { return _background; }
        void		SetBackground(bool background) { _background = background; }

        int		GetBackgroundColor() { return _backgroundColor; }
        void		SetBackgroundColor(int red, int green, int blue) { _backgroundColor = makecol(red, green, blue); SetBackground(true); }
        void		SetBackgroundColor(int backgroundColor) { _backgroundColor = backgroundColor; SetBackground(true); }

        const char*	GetText() { return _text; }
        void		SetText(const char *text);

        virtual int	GetTextColor() { return _textColor; }
        void		SetTextColor(int red, int green, int blue) { _textColor = makecol(red, green, blue); };
        void		SetTextColor(int color) { _textColor = color; };

        void		SetParent(Menu *parent) { _parent = parent; };
        Menu*		GetParent() { return _parent; }

        void		SetEnabled(bool enabled) { _enabled = enabled; }
        void		SetVisible(bool visible) { _visible = visible; }

        bool		IsEnabled() { return _enabled; }
        bool		IsVisible() { return _visible; }

        void		SetPos(int x, int y);
        void		SetX(int x);
        void		SetY(int y);

        int		GetX();
        int		GetY();

        int		GetW();
        int		GetH();

        bool		IsMouseOver() { return _mouseOver; };

        void		Draw();
        void		Tick();

    private:

        void	UpdateMouseOverState();
        bool	BeginsToBePressedByMouseLeft(bool mouseKeyHolding);
        bool	BeginsToBePressedByMouseRight(bool mouseKeyHolding);
        bool	BeginsToBePressedByMouseMiddle(bool mouseKeyHolding);

        Menu*	_parent;

        bool	_enabled;
        bool	_visible;

        bool	_borderLine;
        bool	_background;

        int	_posX;
        int	_posY;

        char	_text[64];

        int	_backgroundColor;
        int	_textColor;
        int	_borderLineColor;

        bool	_mouseOver;
        bool	_isBeingPressedByMouseLeft;
        bool	_isBeingPressedByMouseRight;
        bool	_isBeingPressedByMouseMiddle;

    };
}

#endif //LMENU_ITEM_H
