#ifndef MainMenu_h
#define MainMenu_h

#include "../BaseMenu.h"

class MainMenu : public BaseMenu
{
public:
	MainMenu(AllegroGame* game) : BaseMenu(game)
	{
                SetTitle("");

		Add(startGame = new BaseItem(this, ""));
		Add(options = new BaseItem(this, "Options"));
		Add(quit = new BaseItem(this, "Quit"));

		_type = MENU_MAIN;
	}

	virtual ~MainMenu() {}

        virtual void Show() {
            lmenu::Menu::Show();
            const char* startGameText = (_game->GetState() == Game::STATE_NEW) ? "Start New Game" : "Resume Game";
            startGame->SetText(startGameText);
            Center();
        }

	virtual void EventOccurred(lmenu::Event e)
	{
		BaseMenu::EventOccurred(e);

		if(e.GetType() == lmenu::Event::CLICKED_LEFT)
		{
			if(e.GetSource() == startGame)
			{
                                Hide();
                                if(_game->GetState() == Game::STATE_NEW) {
                                    _game->Start();
                                } else {
                                    _game->Resume();
                                }
			}
			else if(e.GetSource() == options)
			{
                                Hide();

                                _game->GetMenu(MENU_OPTIONS)->Show();
			}
			else if(e.GetSource() == quit)
			{
				if(_game->GetState() == Game::STATE_NEW)
				{
					_game->Exit();
				}
				else
				{
					Hide();
					_game->GetMenu(MENU_EXIT)->Show();
				}
			}
		}
	}

private:
	BaseItem* startGame;
	BaseItem* options;
	BaseItem* quit;
};
#endif
