#include "Inventory.h"
#include "PlayerTypes.h"

Inventory::Inventory(Game* game, Vehicle* owner) {
    _game = game;
    _owner = owner;

    for (int i = 0; i < _size; i++) {
        _slot[i] = NULL;
    }
}

Inventory::~Inventory() {
    Clear();
}

bool Inventory::IsEmpty() {
    for (int i = 0; i < _size; i++) {
        if (_slot[i] != NULL) {
            return false;
        }
    }
    return true;
}

void Inventory::Add(Weapon* weapon) {
    if (_size == 0) {
        return;
    }
    if (_slot[_size - 1] != NULL) {
        delete _slot[_size - 1];
    }
    for (int i = _size - 2; i >= 0; i--) {
        _slot[i + 1] = _slot[i];
    }
    _slot[0] = weapon;
}

Weapon* Inventory::Take() {
    Weapon* takenWeapon = _slot[0];
    for (short i = 1; i <= _size - 1; i++) {
        _slot[i - 1] = _slot[i];
    }
    _slot[_size - 1] = NULL;
    return takenWeapon;
}

void Inventory::Rotate() {
    short itemsCount = 0;
    for (short i = 0; i < _size; i++) {
        if (_slot[i] != NULL) {
            itemsCount++;
        }
    }

    if (itemsCount <= 1) {
        return;
    }

    Weapon* tempWeapon = _slot[0];
    for (short i = 1; i <= itemsCount - 1; i++) {
        _slot[i - 1] = _slot[i];
    }
    _slot[itemsCount - 1] = tempWeapon;
}

void Inventory::Clear() {
    for (int i = 0; i < _size; i++) {
        if (_slot[i] != NULL) {
            delete _slot[i];
            _slot[i] = NULL;
        }
    }
}

Weapon* Inventory::GetItemAt(int index) {
    return _slot[index];
}

int Inventory::CountItems() {
    int count = 0;
    for (int i = 0; i < _size; i++) {
        if (_slot[i] != NULL) {
            count++;
        }
    }
    return count;
}

short Inventory::GetSize() {
    return _size;
}

void Inventory::Draw() {
    InfoPanel* infoPanel = _game->GetInfoPanel();
    const int ownerID = _owner->GetOwner()->GetIDNumber();
    const double margin = 8.0;
    const double slotDistance = 40.0;
    const double requiredSpaceX = (_size + 1) * slotDistance;
    const double providedSpaceX = ((infoPanel->GetW() - 2.0 * margin) / MAX_PLAYERS_COUNT);
    const char* label = ownerID == 1 ? "1" : ownerID == 2 ? "2" : ownerID == 3 ? "3" : ownerID == 4 ? "4" : "?";
    for(int i=0; i < _size + 1; i++) {
        const double x = margin + providedSpaceX * (ownerID - 1) + providedSpaceX/2 - requiredSpaceX / 2.0 + i * slotDistance + slotDistance / 2 * 0;
        const double y = infoPanel->GetH() / 2;
        Vector2D pos(x, y);
        if(i == 0) {
            infoPanel->DrawText(label, pos, _owner->GetColor(), true);
        } else {
            infoPanel->DrawSlot(pos, true);
            Weapon* weapon = GetItemAt(i - 1);
            if(weapon != NULL) {
                infoPanel->DrawWeaponIcon(weapon->GetType(), pos, true);
            }
        }
    }
}
