#ifndef BLITFILL_H
#define BLITFILL_H

#include <allegro.h>

//blits a bitmap onto another bitmap filling an area

static void blitfill(BITMAP *source, BITMAP *dest, int pos_x, int pos_y, int size_x, int size_y) {
    for (int y = pos_y; y < pos_y + size_y; y += source->h) {
        for (int x = pos_x; x < pos_x + size_x; x += source->w) {
            int cutX = 0;
            int cutY = 0;
            if (x > pos_x + size_x - source->w)
                cutX = pos_x + size_x - x;
            if (y > pos_y + size_y - source->h)
                cutY = pos_y + size_y - y;
            blit(source, dest, 0, 0, x, y, cutX == 0 ? source->w : cutX, cutY == 0 ? source->h : cutY);
        }
    }
}

#endif //BLITFILL_H
