#ifndef Colors_h
#define Colors_h

#include <allegro.h>

#define TRANSPARENT_COLOR makecol(255, 0, 255)

//the colors that a player can choose

enum PLAYER_COLOR {
    PLAYER_COLOR_RED,
    PLAYER_COLOR_GREEN,
    PLAYER_COLOR_YELLOW,
    PLAYER_COLOR_DARK_BLUE,
    PLAYER_COLOR_PINK,
    PLAYER_COLOR_BRIGHT_BLUE,

    PLAYER_COLOR_COUNT
};

//create a color code for a certain color name

static int MakePlayerColor(PLAYER_COLOR color) {
    return
            color == PLAYER_COLOR_RED ? makecol(255, 0, 0) :
            color == PLAYER_COLOR_GREEN ? makecol(0, 255, 0) :
            color == PLAYER_COLOR_YELLOW ? makecol(255, 255, 0) :
            color == PLAYER_COLOR_DARK_BLUE ? makecol(0, 80, 255) :
            color == PLAYER_COLOR_PINK ? makecol(255, 5, 255) :
            color == PLAYER_COLOR_BRIGHT_BLUE ? makecol(0, 255, 255) :
            -1;
}

//the colors that buttons can use

enum BUTTON_COLOR {
    BUTTON_COLOR_NORMAL,
    BUTTON_COLOR_MOUSE_OVER,
    BUTTON_COLOR_ENABLED,
    BUTTON_COLOR_DISABLED,

    BUTTON_COLOR_COUNT
};

//create a color code for a certain color name

static int MakeButtonColor(BUTTON_COLOR color) {
    return
            color == BUTTON_COLOR_NORMAL ? makecol(170, 170, 0) :
            color == BUTTON_COLOR_MOUSE_OVER ? makecol(255, 255, 100) :
            color == BUTTON_COLOR_ENABLED ? makecol(200, 200, 0) :
            color == BUTTON_COLOR_DISABLED ? makecol(127, 127, 127) :
            -1;
}

static int DarkenColor(int color) {
    const float factor = 0.8;
    const float r = getr(color) * factor;
    const float g = getg(color) * factor;
    const float b = getb(color) * factor;
    return makecol((int)r, (int)g, (int)b);
}

#endif
