#include "menu.h"

lmenu::Menu::Menu() {
    _destBitmap = screen;

    _visible = true;
    _enabled = true;

    _offsetX = 0;
    _offsetY = 0;

    _borderLine = true;
    _borderLineColor = makecol(255, 127, 0);

    _background = true;
    _backgroundColor = makecol(127, 127, 127);

    _borderSpace = 5;
    _itemBorderSpace = 5;

    _layout = Menu::LAYOUT_VERTICALLY_CENTERED;

    _font = font;

    strcpy(_title, "?");

    _textMulticolored = false;
    _textColor = makecol(255, 127, 0);

    _posX = 0;
    _posY = 0;

    SetAutoSize(true);
}

lmenu::Menu::~Menu() {

}

void lmenu::Menu::Draw() {
    if (_visible) {
        if (HasBackground()) {
            rectfill(_destBitmap, _posX, _posY, _posX + _sizeW, _posY + _sizeH, _backgroundColor);
        }

        if (_borderLine) {
            hline(_destBitmap, _posX, _posY, _posX + _sizeW, _borderLineColor);
            hline(_destBitmap, _posX, _posY + _sizeH, _posX + _sizeW, _borderLineColor);
            vline(_destBitmap, _posX, _posY, _posY + _sizeH, _borderLineColor);
            vline(_destBitmap, _posX + _sizeW, _posY, _posY + _sizeH, _borderLineColor);
        }

        int x = _sizeW / 2 - text_length(_font, _title) / 2;

        textout_ex(_destBitmap, _font, _title, _posX + x, _posY + GetBorderSpace(), _textMulticolored ? -1 : _textColor, -1);

        for (int i = 0; i < GetItemCount(); i++) {
            _items.at(i)->Draw();
        }
    }
}

void lmenu::Menu::Tick() {
    if (_enabled) {
        for (int i = 0; i < GetItemCount(); i++) {
            _items.at(i)->Tick();
        }
    } else {
        return;
    }
}

void lmenu::Menu::Add(Item *i) {
    _items.push_back(i);
    UpdateSize();
}

void lmenu::Menu::Remove(Item *i) {
    _items.erase(find(_items.begin(), _items.end(), i));
    UpdateSize();
}

int lmenu::Menu::GetItemIndex(Item* item) {
    for (int i = 0; i < GetItemCount(); i++) {
        if (item == _items.at(i)) {
            return i;
        }
    }

    return -1;
}

void lmenu::Menu::SetAutoSize(bool autoSize) {
    _autoSize = autoSize;

    UpdateSize();
}

void lmenu::Menu::UpdateSize() {
    if (IsAutoSize()) {
        if (GetLayout() == LAYOUT_CUSTOM_POS) {
            int m_x = 0;
            int m_y = 0;

            for (int i = 0; i < GetItemCount(); i++) {
                int x = _items.at(i)->GetX() + _items.at(i)->GetW();
                int y = _items.at(i)->GetY() + _items.at(i)->GetH();

                if (x > m_x) {
                    m_x = x;
                }

                if (y > m_y) {
                    m_y = y;
                }
            }

            _sizeW = m_x + GetBorderSpace();
            _sizeH = m_y + GetBorderSpace();

            int t_w = GetBorderSpace()*2 + text_length(GetFont(), GetTitle());
            if (t_w > _sizeW) {
                _sizeW = t_w;
            }
        } else if (GetLayout() == LAYOUT_VERTICALLY_CENTERED || GetLayout() == LAYOUT_VERTICALLY_LEFT) {
            int m_x = 0;

            for (int i = 0; i < GetItemCount(); i++) {
                int x = _items.at(i)->GetW();

                if (x > m_x) {
                    m_x = x;
                }
            }

            _sizeW = m_x + GetBorderSpace()*2;
            _sizeH = GetBorderSpace()*2 + GetFont()->height + (GetFont()->height + GetItemBorderSpace()*2 + GetBorderSpace()) * GetItemCount();

            int t_w = GetBorderSpace()*2 + text_length(GetFont(), GetTitle());
            if (t_w > _sizeW) {
                _sizeW = t_w;
            }
        } else if (GetLayout() == LAYOUT_HORIZONTALLY_CENTERED) {
            int w = GetBorderSpace();
            for (int i = 0; i < GetItemCount(); i++) {
                w += GetItemByIndex(i)->GetW() + GetBorderSpace();
            }
            _sizeW = w;
            _sizeH = GetBorderSpace()*3 + (GetFont()->height)*2 + GetItemBorderSpace()*2;

            int t_w = GetBorderSpace()*2 + text_length(GetFont(), GetTitle());
            if (t_w > _sizeW) {
                _sizeW = t_w;
            }
        }
    }
}

void lmenu::Menu::SetTitle(const char *title) {
    strcpy(_title, title);
    UpdateSize();
}

lmenu::Item* lmenu::Menu::GetItemByIndex(int index) {
    if (index < 0 || index >= GetItemCount()) {
        return NULL;
    }

    return _items.at(index);
}
