#include "item.h"

lmenu::Item::Item(Menu *parent, int posX, int posY) {
    _parent = parent;

    Init();

    SetPos(posX, posY);
}

lmenu::Item::Item(Menu *parent, const char* text, int posX, int posY) {
    _parent = parent;

    Init();

    SetText(text != NULL ? text : "");

    SetPos(posX, posY);
}

lmenu::Item::~Item() {

}

void lmenu::Item::Draw() {
    if (_visible) {
        int x = GetX() + _parent->GetX();
        int y = GetY() + _parent->GetY();

        if (HasBackground()) {
            rectfill(_parent->GetDestinationBitmap(), x, y, x + GetW(), y + GetH(), GetBackgroundColor());
        }

        if (_borderLine) {
            hline(_parent->GetDestinationBitmap(), x, y, x + GetW(), _borderLineColor);
            hline(_parent->GetDestinationBitmap(), x, y + GetH(), x + GetW(), _borderLineColor);
            vline(_parent->GetDestinationBitmap(), x, y, y + GetH(), _borderLineColor);
            vline(_parent->GetDestinationBitmap(), x + GetW(), y, y + GetH(), _borderLineColor);
        }

        x += GetW() / 2 - text_length(_parent->GetFont(), _text) / 2;
        y += GetH() / 2 - text_height(_parent->GetFont()) / 2;

        textout_ex(_parent->GetDestinationBitmap(), _parent->GetFont(), _text, x, y, _parent->IsTextMulticolored() ? -1 : GetTextColor(), -1);
    }
}

void lmenu::Item::UpdateMouseOverState() {
    int x = GetX() + _parent->GetX();
    int y = GetY() + _parent->GetY();

    if (mouse_x - _parent->GetOffsetX() >= x && mouse_x - _parent->GetOffsetX() <= x + GetW() &&
            mouse_y - _parent->GetOffsetY() >= y && mouse_y - _parent->GetOffsetY() <= y + GetH()) {
        if (_mouseOver == false) {
            _mouseOver = true;
            if (_enabled) {
                _parent->EventOccurred(Event(Event::MOUSE_OVER, this));
            }
        }
    } else {
        if (_mouseOver == true) {
            _mouseOver = false;
            if (_enabled) {
                _parent->EventOccurred(Event(Event::MOUSE_LEAVES, this));
            }
        }
    }
}

bool lmenu::Item::BeginsToBePressedByMouseLeft(bool mouseKeyHolding) {
    if (mouseKeyHolding) {
        if (_isBeingPressedByMouseLeft) {
            return false;
        } else {
            if (IsMouseOver()) {
                _isBeingPressedByMouseLeft = true;
                return true;
            } else {
                _isBeingPressedByMouseLeft = true;
                return false;
            }
        }
    } else {
        if (_isBeingPressedByMouseLeft) {
            _isBeingPressedByMouseLeft = false;
            return false;
        } else {
            return false;
        }
    }
}

bool lmenu::Item::BeginsToBePressedByMouseRight(bool mouseKeyHolding) {
    if (mouseKeyHolding) {
        if (_isBeingPressedByMouseRight) {
            return false;
        } else {
            if (IsMouseOver()) {
                _isBeingPressedByMouseRight = true;
                return true;
            } else {
                _isBeingPressedByMouseRight = true;
                return false;
            }
        }
    } else {
        if (_isBeingPressedByMouseRight) {
            _isBeingPressedByMouseRight = false;
            return false;
        } else {
            return false;
        }
    }
}

bool lmenu::Item::BeginsToBePressedByMouseMiddle(bool mouseKeyHolding) {
    if (mouseKeyHolding) {
        if (_isBeingPressedByMouseMiddle) {
            return false;
        } else {
            if (IsMouseOver()) {
                _isBeingPressedByMouseMiddle = true;
                return true;
            } else {
                _isBeingPressedByMouseMiddle = true;
                return false;
            }
        }
    } else {
        if (_isBeingPressedByMouseMiddle) {
            _isBeingPressedByMouseMiddle = false;
            return false;
        } else {
            return false;
        }
    }
}

void lmenu::Item::Tick() {
    UpdateMouseOverState();

    if (_enabled) {
        if (BeginsToBePressedByMouseLeft((bool)(mouse_b & 0x01))) {
            _parent->EventOccurred(Event(Event::CLICKED_LEFT, this));
        }
        if (BeginsToBePressedByMouseRight((bool)(mouse_b & 0x02))) {
            _parent->EventOccurred(Event(Event::CLICKED_RIGHT, this));
        }
        if (BeginsToBePressedByMouseMiddle((bool)(mouse_b & 0x04))) {
            _parent->EventOccurred(Event(Event::CLICKED_MIDDLE, this));
        }
    }
}

int lmenu::Item::GetX() {
    if (_parent->GetLayout() == Menu::LAYOUT_CUSTOM_POS) {
        return _posX;
    } else if (_parent->GetLayout() == Menu::LAYOUT_VERTICALLY_LEFT) {
        return _parent->GetBorderSpace();
    } else if (_parent->GetLayout() == Menu::LAYOUT_VERTICALLY_CENTERED) {
        int w = text_length(_parent->GetFont(), GetText()) + _parent->GetItemBorderSpace()*2;
        int m_w = _parent->GetW();
        return m_w / 2 - w / 2;
    } else if (_parent->GetLayout() == Menu::LAYOUT_HORIZONTALLY_CENTERED) {
        int m_w = _parent->GetW();
        int w = _parent->GetBorderSpace();
        for (int i = 0; i < _parent->GetItemCount(); i++) {
            w += _parent->GetItemByIndex(i)->GetW() + _parent->GetBorderSpace();
        }
        int x = (m_w / 2 - w / 2) + _parent->GetBorderSpace();
        for (int i = 0; i < _parent->GetItemIndex(this); i++) {
            x += _parent->GetItemByIndex(i)->GetW() + _parent->GetBorderSpace();
        }
        return x;
    } else {
        return -1;
    }
}

int lmenu::Item::GetY() {
    if (_parent->GetLayout() == Menu::LAYOUT_CUSTOM_POS) {
        return _posY;
    } else if (_parent->GetLayout() == Menu::LAYOUT_VERTICALLY_LEFT) {
        return _parent->GetBorderSpace()*2 + _parent->GetFont()->height + (_parent->GetBorderSpace() + _parent->GetItemBorderSpace()*2 + _parent->GetFont()->height) * _parent->GetItemIndex(this);
    } else if (_parent->GetLayout() == Menu::LAYOUT_VERTICALLY_CENTERED) {
        return _parent->GetBorderSpace()*2 + _parent->GetFont()->height + (_parent->GetBorderSpace() + _parent->GetItemBorderSpace()*2 + _parent->GetFont()->height) * _parent->GetItemIndex(this);
    } else if (_parent->GetLayout() == Menu::LAYOUT_HORIZONTALLY_CENTERED) {
        return _parent->GetBorderSpace()*2 + _parent->GetFont()->height;
    } else {
        return -1;
    }
}

int lmenu::Item::GetW() {
    return _parent->GetItemBorderSpace()*2 + text_length(_parent->GetFont(), _text);
}

int lmenu::Item::GetH() {
    return _parent->GetItemBorderSpace()*2 + _parent->GetFont()->height;
}

void lmenu::Item::Init() {
    _enabled = true;
    _visible = true;

    _posX = 1;
    _posY = 1;

    strcpy(_text, "?");

    _backgroundColor = makecol(80, 80, 80);
    _borderLineColor = makecol(255, 255, 0);
    _textColor = makecol(255, 255, 0);

    SetBackground(true);
    SetBorderLine(true);

    _mouseOver = false;

    _isBeingPressedByMouseLeft = true;
    _isBeingPressedByMouseRight = true;
    _isBeingPressedByMouseMiddle = true;
}

void lmenu::Item::SetText(const char *text) {
    strcpy(_text, text);
    _parent->UpdateSize();
}

void lmenu::Item::SetPos(int x, int y) {
    _posX = x;
    _posY = y;
    _parent->UpdateSize();
}

void lmenu::Item::SetX(int x) {
    _posX = x;
    _parent->UpdateSize();
}

void lmenu::Item::SetY(int y) {
    _posY = y;
    _parent->UpdateSize();
}
