#ifndef SummaryMenu_h
#define SummaryMenu_h

#include "../BaseMenu.h"

class SummaryMenu : public BaseMenu {
public:

    SummaryMenu(AllegroGame* game) : BaseMenu(game) {
        SetTitle("--- Scores ---");

        for (int i = 0; i < MAX_PLAYERS_COUNT; i++) {
            Add(playerInfo[i] = new BaseItem(this, "?"));
        }

        Add(nextRound = new BaseItem(this, "next round"));

        this->SetBorderLine(true);
        this->SetBackground(true);
        this->SetBackgroundColor(0, 0, 0);

        _type = MENU_SUMMARY;

        Hide();
    }

    virtual ~SummaryMenu() {
    }

    virtual void Show() {
        lmenu::Menu::Show();
        UpdateInfo();
    }

    void UpdateInfo() {
        BaseMenu::Show();

        for (int i = 0; i < MAX_PLAYERS_COUNT; i++) {
            char s[32];
            sprintf(s, "Player %i:  +%i   Total: %i", i + 1, _game->GetPlayer(i)->GetRoundScore(), _game->GetPlayer(i)->GetTotalScore());
            playerInfo[i]->SetText(s);
            playerInfo[i]->SetTextColor(_game->GetPlayer(i)->IsEnabled() ? _game->GetPlayer(i)->GetColor() : MakeButtonColor(BUTTON_COLOR_DISABLED));
        }

        Center();
    }

    virtual void EventOccurred(lmenu::Event e) {
        if (e.GetSource() == nextRound) {
            if (e.GetType() == lmenu::Event::CLICKED_LEFT) {
                Hide();
                _game->Start();
            } else if (e.GetType() == lmenu::Event::MOUSE_OVER) {
                e.GetSource()->SetTextColor(MakeButtonColor(BUTTON_COLOR_MOUSE_OVER));
            } else if (e.GetType() == lmenu::Event::MOUSE_LEAVES) {
                e.GetSource()->SetTextColor(MakeButtonColor(BUTTON_COLOR_NORMAL));
            }
        }
    }

private:
    BaseItem* playerInfo[MAX_PLAYERS_COUNT];
    BaseItem* nextRound;
};

#endif //SummaryMenu_h
