#ifndef InfoPanel_h
#define	InfoPanel_h

#include "Game.h"

class Game;

class InfoPanel {
public:
    InfoPanel(Game* game, const Vector2D& pos, const Vector2D& size);
    virtual ~InfoPanel();

    double GetX() { return _pos.x; }
    double GetY() { return _pos.y; }
    const Vector2D& GetPos() { return _pos; }
    void SetX(double x) { _pos.x = x; }
    void SetY(double y) { _pos.y = y; }
    void SetPos(const Vector2D& pos) { _pos = pos; }
    double GetW() { return _size.x; }
    double GetH() { return _size.y; }
    const Vector2D& GetSize() { return _size; }
    void SetH(double h) { _size.x = h; }
    void SetW(double w) { _size.y = w; }
    void SetSize(const Vector2D& size) { _size = size; }

    virtual void Draw() = 0;
    virtual void DrawText(const char* text, const Vector2D& pos, int color, bool centered) = 0;
    virtual void DrawSlot(const Vector2D& pos, bool centered) = 0;
    virtual void DrawWeaponIcon(WEAPON_TYPE weaponType, const Vector2D& pos, bool centered) = 0;

protected:
    Game* _game;

    Vector2D _pos;
    Vector2D _size;
};

class AllegroGame;

class AllegroInfoPanel : public InfoPanel {
public:
    AllegroInfoPanel(Game* game, const Vector2D& pos, const Vector2D& size);
    virtual ~AllegroInfoPanel();

    virtual AllegroGame* GameImplementation() { return (AllegroGame*) _game; }

    virtual void Draw();
    virtual void DrawText(const char* text, const Vector2D& pos, int color, bool centered);
    virtual void DrawSlot(const Vector2D& pos, bool centered);
    virtual void DrawWeaponIcon(WEAPON_TYPE weaponType, const Vector2D& pos, bool centered);
};

#endif	/* InfoPanel_h */
