#include "Configuration.h"

Configuration::Configuration() {
    _resPresetX[0] = 0;
    _resPresetY[0] = 0;

    _resPresetX[1] = 800;
    _resPresetY[1] = 600;

    _resPresetX[2] = 1024;
    _resPresetY[2] = 768;

    _resPresetX[3] = 1280;
    _resPresetY[3] = 1024;

    _resPresetX[4] = 1600;
    _resPresetY[4] = 900;

    _resPresetX[5] = 1920;
    _resPresetY[5] = 1200;

    _resPresetString[0] = "custom resolution";
    _resPresetString[1] = "800 x 600";
    _resPresetString[2] = "1024 x 768";
    _resPresetString[3] = "1280 x 1024";
    _resPresetString[4] = "1600 x 900";
    _resPresetString[5] = "1920 x 1200";
}

Configuration::~Configuration() {

}

void Configuration::ChangeResolution() {
    int resPresetIndex = (FindResolutionPresetIndex() + 1) % _resPresetCount;
    if (resPresetIndex == 0) {
        resPresetIndex++;
    }
    _resolutionX = _resPresetX[resPresetIndex];
    _resolutionY = _resPresetY[resPresetIndex];
}

void Configuration::ChangeToLowestResolution() {
    _resolutionX = _resPresetX[1];
    _resolutionY = _resPresetY[1];
}

void Configuration::ChangePlayerType(int playerIndex) {
    _playerType[playerIndex] = (PLAYER_TYPE) ((_playerType[playerIndex] + 1) % PLAYER_TYPES_COUNT);
}

bool Configuration::IsPlayerEnabled(int playerIndex) {
    return _playerType[playerIndex] != PLAYER_TYPE_NONE;
}

const char* Configuration::GetResString() {
    return _resPresetString[FindResolutionPresetIndex()];
}

int Configuration::FindResolutionPresetIndex() {
    int presetIndex = 0;
    for (int i = 0; i < _resPresetCount; i++) {
        if (_resolutionX == _resPresetX[i] && _resolutionY == _resPresetY[i]) {
            presetIndex = i;
            break;
        }
    }
    return presetIndex;
}

//Allegro:

void AllegroConfiguration::Load(const char* filename) {
    set_config_file(filename);

    _resolutionX = get_config_int("graphics", "resolution_x", 0);
    _resolutionY = get_config_int("graphics", "resolution_y", 0);
    _fullscreen = strcmp(get_config_string("graphics", "fullscreen", NULL), "yes") == 0 ? true : false;

    _maxFieldWeaponsCount = get_config_int("game", "weapons_on_field", 0);
    _thickLines = strcmp(get_config_string("game", "thick_walls", NULL), "yes") == 0 ? true : false;

    for (int i = 0; i < MAX_PLAYERS_COUNT; i++) {
        const char* plrstr = i == 0 ? "player1" : i == 1 ? "player2" : i == 2 ? "player3" : "player4";

        _playerKeyCode[i][PLAYER_COMMAND_TURN_LEFT] = get_config_int(plrstr, "key_left", 0);
        _playerKeyCode[i][PLAYER_COMMAND_TURN_RIGHT] = get_config_int(plrstr, "key_right", 0);
        _playerKeyCode[i][PLAYER_COMMAND_USE_WEAPON] = get_config_int(plrstr, "key_use", 0);
        _playerKeyCode[i][PLAYER_COMMAND_SELECT_WEAPON] = get_config_int(plrstr, "key_select", 0);

        _playerColor[i] = (PLAYER_COLOR) get_config_int(plrstr, "color", 0);
        _playerType[i] = (PLAYER_TYPE) get_config_int(plrstr, "type", 0);
    }
}

void AllegroConfiguration::Save(const char* filename) {
    set_config_file(filename);

    set_config_int("graphics", "resolution_x", _resolutionX);
    set_config_int("graphics", "resolution_y", _resolutionY);
    set_config_string("graphics", "fullscreen", _fullscreen ? "yes" : "no");

    set_config_int("game", "weapons_on_field", _maxFieldWeaponsCount);
    set_config_string("game", "thick_walls", _thickLines ? "yes" : "no");

    for (int i = 0; i < MAX_PLAYERS_COUNT; i++) {
        const char* plrstr = i == 0 ? "player1" : i == 1 ? "player2" : i == 2 ? "player3" : "player4";

        set_config_int(plrstr, "key_left", _playerKeyCode[i][PLAYER_COMMAND_TURN_LEFT]);
        set_config_int(plrstr, "key_right", _playerKeyCode[i][PLAYER_COMMAND_TURN_RIGHT]);
        set_config_int(plrstr, "key_use", _playerKeyCode[i][PLAYER_COMMAND_USE_WEAPON]);
        set_config_int(plrstr, "key_select", _playerKeyCode[i][PLAYER_COMMAND_SELECT_WEAPON]);

        set_config_int(plrstr, "color", _playerColor[i]);
        set_config_int(plrstr, "type", _playerType[i]);
    }

    flush_config_file();
}
