#ifndef Particle_h
#define Particle_h

#include "../Game.h"

//abstract
class Particle {
public:

    Particle(Game* game, const Vector2D& pos, double directionAngle, double speed, int radius, int color) {
        _game = game;
        SetPos(pos);
        SetDirection(directionAngle);
        SetSpeed(speed);
        SetRadius(radius);
        SetColor(color);
    }

    virtual ~Particle() {
    }

    void SetPos(const Vector2D& pos) {
        _pos = pos;
    }
    
    const Vector2D& GetPos() {
        return _pos;
    }

    void SetColor(int color) {
        _color = color;
    }

    void SetColor(int red, int green, int blue) {
        _color = makecol(red, green, blue);
    }

    void SetRadius(int radius) {
        _radius = radius;
    }

    void SetDirection(double angle) {
        _direction = angle;
    }

    void SetSpeed(double speed) {
        _speed = speed;
    }

    void MoveBy(double distance) {
        _pos.x += cos(_direction) * distance;
        _pos.y += sin(_direction) * distance;
    }

    virtual void Tick() {
        _pos.x += cos(_direction) * _speed;
        _pos.y += sin(_direction) * _speed;
    }

    virtual void Draw() {
        _game->GetLog()->LogFatal("This is the Draw method of the abstract class Particle");
    }

protected:
    Game* _game;

    Vector2D _pos;
    int _radius; //size
    int _color;
    double _direction; //angle
    double _speed;
};

#endif //Particle_h
