#ifndef Missile_h
#define Missile_h

#include "Particle.h"

class Missile : public Particle {
public:

    Missile(Game* game, const Vector2D& pos, double directionAngle, double speed, int radius, int color) : Particle(game, pos, directionAngle, speed, radius, color) {
        _dead = false;
    }

    virtual ~Missile() {
    }

    bool IsDead() { return _dead; }
    void Die() { _dead = true; }

    double GetX() { return _pos.x; }
    double GetY() { return _pos.y; }

    double GetDirection() { return _direction; }
    double GetSpeed() { return _speed; }

    virtual void Tick() {
        if (_dead) {
            return;
        }

        Particle::Tick();
    }

    virtual void Draw() {
        if (_dead) {
            return;
        }

        _game->GetArena()->DrawCircle(_pos, _radius, _color, true);
    }

protected:
    bool _dead;
};

#endif //Missile_h
