#ifndef WallWeapon_h
#define WallWeapon_h

#include "../Weapon.h"
#include <math.h>

class WallWeapon : public Weapon {
public:

    WallWeapon(Game* game, Vehicle *owner, WEAPON_TYPE type) : Weapon(game, owner, type) {

    }

    virtual ~WallWeapon() {
    }

    virtual void Activate() {
        Weapon::Activate();
    }

    virtual void Tick() {
        double wallPieceDist = 1.0f;

        Vector2D u(_owner->GetAngle());
        Vector2D temp = _owner->GetPos() - u;
        Vector2D newPos;

        while (temp.x >= 0 && temp.x < _game->GetArena()->GetW() && temp.y >= 0 && temp.y < _game->GetArena()->GetH()) {
            newPos.x = temp.x - sin(_owner->GetAngle()) * wallPieceDist;
            newPos.y = temp.y + cos(_owner->GetAngle()) * wallPieceDist;
            _game->GetArena()->PlaceLine(temp, newPos, _owner->GetColor());
            temp = newPos;
        }

        temp = _owner->GetPos() - u;

        while (temp.x >= 0 && temp.x < _game->GetArena()->GetW() && temp.y >= 0 && temp.y < _game->GetArena()->GetH()) {
            newPos.x = temp.x + sin(_owner->GetAngle()) * wallPieceDist;
            newPos.y = temp.y - cos(_owner->GetAngle()) * wallPieceDist;
            _game->GetArena()->PlaceLine(temp, newPos, _owner->GetColor());
            temp = newPos;
        }

        CountTimeAndFinalize();
    }
};

#endif
