#ifndef HomingWeapon_h
#define HomingWeapon_h

#include "../Weapon.h"
#include "../Missile.h"

class HomingWeapon : public Weapon {
public:

    HomingWeapon(Game* game, Vehicle *owner, WEAPON_TYPE type) : Weapon(game, owner, type) {
        _missile = NULL;
    }

    virtual ~HomingWeapon() {
    }

    virtual void Activate() {
        Weapon::Activate();

        ChooseTarget();

        _missile = new Missile(_game, _owner->GetPos(), _owner->GetAngle(), _game->GetNormalSpeed()*2.0f, _missileRadius, _owner->GetColor());
        _missile->MoveBy(_missileRadius * 2);
    }

    virtual void Tick() {
        if (_missile != NULL) {
            if (_target->GetState() == Vehicle::STATE_LIVING) {
                double dy = (_target->GetY() - _missile->GetY());
                double dx = (_target->GetX() - _missile->GetX());

                double dist = sqrt(dx * dx + dy * dy);
                dy /= dist * dist * 0.01;
                dx /= dist * dist * 0.01;

                double ay = sin(_missile->GetDirection()) * _missile->GetSpeed();
                double ax = cos(_missile->GetDirection()) * _missile->GetSpeed();

                double rx = dx + ax;
                double ry = dy + ay;

                double angle = atan2(ry, rx);
                _missile->SetDirection(angle);
            }

            _missile->Tick();

            Vector2D pos(_missile->GetX(), _missile->GetY());
            Vector2D scanLine(_missile->GetDirection(), _missile->GetSpeed(), true);
            const double collisionDist = _game->GetArena()->CalcShortestCollisionDist(pos, scanLine);
            if (collisionDist <= _missile->GetSpeed()) {
                _game->PlaySound(Game::SOUND_MISSILE, _game->GetArena()->GetPan(_missile->GetX()));
                _missile->Die();
            }

            if (_missile->IsDead()) {
                _game->GetArena()->PlaceCircle(pos, 20, _owner->GetColor(), true);

                delete _missile;
                _missile = NULL;

                CountTimeAndFinalize();
            }
        }
    }

    virtual void Draw() {
        if (_missile != NULL) {
            _missile->Draw();
        }
    }

private:
    Missile *_missile;
    const static int _missileRadius = 5;
};

#endif
