#ifndef ClusterWeapon_h
#define ClusterWeapon_h

#include "../Weapon.h"
#include "../Shive.h"

class ClusterWeapon : public Weapon {
public:

    ClusterWeapon(Game* game, Vehicle *owner, WEAPON_TYPE type) : Weapon(game, owner, type) {
        _shiveDirectionCount = 1000;
    }

    virtual ~ClusterWeapon() {
    }

    virtual void Activate() {
        Weapon::Activate();

        for (int i = 0; i < _shiveCount; i++) {
            double direction = ((PI * 2.0) / ((double) _shiveDirectionCount))*((double) (rand() % _shiveDirectionCount));
            double speed = _game->GetNormalSpeed()*2.5 + ((double) (rand() % 100)) / 50.0;
            _shives[i] = new Shive(_game, _owner->GetPos(), direction, speed, 2, _owner->GetColor());
            _shives[i]->MoveBy(_shiveRadius * 2);
        }
    }

    virtual void Tick() {
        short shivesLeft = _shiveCount;
        for (int i = 0; i < _shiveCount; i++) {
            _shives[i]->Tick();

            if (_shives[i]->IsDead())
                shivesLeft--;
        }

        if (shivesLeft == 0) {
            for (int i = 0; i < _shiveCount; i++) {
                delete _shives[i];
            }

            CountTimeAndFinalize();
        }
    }

    virtual void Draw() {
        for (int i = 0; i < _shiveCount; i++) {
            _shives[i]->Draw();
        }
    }

private:

    const static short _shiveCount = 100;
    Shive* _shives[_shiveCount];
    short _shiveDirectionCount;
    const static int _shiveRadius = 2;
};

#endif
