#ifndef ALLEGROLOG_H
#define	ALLEGROLOG_H

#include <allegro.h>

#include "Log.h"

class AllegroLog : public Log {
public:
    AllegroLog() : Log() {
    }

    AllegroLog(std::string outputFile) : Log(outputFile) {
    }

protected:
    virtual void LogForLevel(LOG_LEVEL level, const std::string &s) {
        Log::LogForLevel(level, s);

        if(level == LEVEL_ERROR) {
            allegro_message("Error: %s", s.c_str());
            //TODO: release c string
        }

        if(level == LEVEL_FATAL) {
            allegro_message("Fatal Error: %s", s.c_str());
            //TODO: release c string
            allegro_exit();
            exit(-1);
        }
    }
};

#endif	/* ALLEGROLOG_H */

