#ifndef OptionsMenu_h
#define OptionsMenu_h

#include "../BaseMenu.h"
#include "MainMenu.h"

//shows game options and player config menus at the same time
class OptionsMenu : public BaseMenu
{
public:
	OptionsMenu(AllegroGame* game) : BaseMenu(game)
	{
		SetTitle("");

                Add(resolution = new BaseItem(this, "Resolution"));
                Add(fullscreen = new BaseItem(this, "Fullscreen"));
                BaseItem* dummyButton = new BaseItem(this, "");
                dummyButton->SetEnabled(false);
                Add(dummyButton); //serves as a separator
                Add(save = new BaseItem(this, "Save"));
		Add(cancel = new BaseItem(this, "Cancel"));

		_type = MENU_OPTIONS;

		this->Hide();
	}

	virtual ~OptionsMenu() {}

        virtual void Show()
        {
                lmenu::Menu::Show();
                UpdateState();

                for(int i=0; i<MAX_PLAYERS_COUNT; i++) {
                    _game->GetMenu((MENU_TYPE)(MENU_PLAYER_CONFIG_1 + i))->Show();
                }
        }

	virtual void EventOccurred(lmenu::Event e)
	{
		BaseMenu::EventOccurred(e);

		if(e.GetType() == lmenu::Event::CLICKED_LEFT)
		{
			if(e.GetSource() == save)
			{
                                _game->GetConfiguration()->Save(CONFIG_FILENAME);
                                HidePlayerConfigMenus();
                                Hide();
				_game->GetMenu(MENU_MAIN)->Show();
			}
                        else if(e.GetSource() == cancel)
			{
                                _game->GetConfiguration()->Load(CONFIG_FILENAME);
                                HidePlayerConfigMenus();
                                Hide();
				_game->GetMenu(MENU_MAIN)->Show();
			}
                        else if(e.GetSource() == resolution)
                        {
                                _game->GetConfiguration()->ChangeResolution();
                                UpdateState();
                        }
                        else if(e.GetSource() == fullscreen)
                        {
                                Configuration* c = _game->GetConfiguration();
                                c->SetFullscreen(!c->IsFullscreen());
                                UpdateState();
                        }
		}
	}

private:
        void HidePlayerConfigMenus() {
            for(int i=0; i<MAX_PLAYERS_COUNT; i++) {
                _game->GetMenu((MENU_TYPE)(MENU_PLAYER_CONFIG_1 + i))->Hide();
            }
        }
        
        void UpdateState() {
            resolution->SetText(_game->GetConfiguration()->GetResString());
            fullscreen->SetText(_game->GetConfiguration()->IsFullscreen() ? "Fullscreen" : "Windowed");
            Center();
        }

private:
        BaseItem* resolution;
        BaseItem* fullscreen;
        BaseItem* save;
	BaseItem* cancel;
        
};
#endif
