#ifndef ExitMenu_h
#define ExitMenu_h

#include "../BaseMenu.h"

class ExitMenu : public BaseMenu
{
public:
	ExitMenu(AllegroGame* game) : BaseMenu(game)
	{
		SetTitle("Do you really want to quit?");

                this->SetLayout(LAYOUT_HORIZONTALLY_CENTERED);

		Add(no = new BaseItem(this, "no"));
		Add(yes = new BaseItem(this, "yes"));

                Center();

		_type = MENU_EXIT;

		Hide();
	}

	virtual ~ExitMenu() {}

	virtual void EventOccurred(lmenu::Event e)
	{
		BaseMenu::EventOccurred(e);

		if(e.GetType() == lmenu::Event::CLICKED_LEFT)
		{
			if(e.GetSource() == yes)
			{
				_game->Exit();
			}
			else if(e.GetSource() == no)
			{
				Hide();
				_game->GetMenu(MENU_MAIN)->Show();
			}
		}
	}

private:
	BaseItem* yes;
	BaseItem* no;
};

#endif
