#include "BaseMenu.h"

BaseMenu::BaseMenu(AllegroGame* game) {
    _game = game;
    SetDestinationBitmap(_game->GetScreenBuffer());
    SetFont(_game->GetFont());
    SetBorderLineColor(200, 100, 0);
    SetBorderLine(false);
    SetTextColor(200, 100, 0);
    SetBackground(false);
}

void BaseMenu::EventOccurred(lmenu::Event e) {
    //general behavior:

    if (e.GetType() == lmenu::Event::MOUSE_OVER) {
        e.GetSource()->SetTextColor(MakeButtonColor(BUTTON_COLOR_MOUSE_OVER));
        _game->PlaySound(Game::SOUND_MOUSE_OVER, 0);
    } else if (e.GetType() == lmenu::Event::MOUSE_LEAVES) {
        e.GetSource()->SetTextColor(MakeButtonColor(BUTTON_COLOR_NORMAL));
    } else if (e.GetType() == lmenu::Event::CLICKED_LEFT) {
        _game->PlaySound(Game::SOUND_MOUSE_CLICK, 0);
    }
}

void BaseMenu::Center() {
    BITMAP* screenBuffer = _game->GetScreenBuffer();
    SetPos(screenBuffer->w/2 - this->GetW()/2, screenBuffer->h/2 - this->GetH()/2);
}
