#ifndef Button_h
#define Button_h

#include "lmenu/menu.h"
#include "../Util/Colors.h"

//general class for other buttons
class BaseItem : public lmenu::Item
{
public:
	BaseItem() {};

	BaseItem(lmenu::Menu *parent, const char* text)
	{
		Init();
		SetParent(parent);
		SetText(text);
		SetBorderLine(false);
		SetBackground(false);

		SetTextColor(MakeButtonColor(BUTTON_COLOR_NORMAL));
	}

	virtual ~BaseItem() {};

        virtual int GetTextColor() {
            int normalColor = lmenu::Item::GetTextColor();
            return IsEnabled() ? normalColor : MakeButtonColor(BUTTON_COLOR_DISABLED);
        }
};
#endif
