#ifndef Inventory_h
#define	Inventory_h

#include "Weapons/Weapon.h"
#include "Game.h"
#include "Vehicle.h"

class Weapon;
class Game;
class Vehicle;

class Inventory {
public:

    Inventory(Game* game, Vehicle* owner);
    virtual ~Inventory();
    Weapon* Take();
    Weapon* GetItemAt(int index);
    void Add(Weapon* weapon);
    void Rotate();
    void Clear();
    bool IsEmpty();
    int CountItems();
    static short GetSize();

    void Draw();

protected:
    Game* _game;
    Vehicle* _owner;

    const static short _size = 3;
    Weapon* _slot[_size];
};

#endif	/* Inventory_h */
