#include "InfoPanel.h"

#include "Util/blitfill.h"

InfoPanel::InfoPanel(Game* game, const Vector2D& pos, const Vector2D& size) {
    _game = game;
    _pos = pos;
    _size = size;
}

InfoPanel::~InfoPanel() {

}

//Allegro

AllegroInfoPanel::AllegroInfoPanel(Game* game, const Vector2D& pos, const Vector2D& size) : InfoPanel(game, pos, size) {

}

AllegroInfoPanel::~AllegroInfoPanel() {

}

void AllegroInfoPanel::Draw() {
    blitfill(GameImplementation()->GetInfoPanelBackgroundBitmap(), GameImplementation()->GetScreenBuffer(), (int)_pos.x, (int)_pos.y, (int)_size.x, (int)_size.y);
}

void AllegroInfoPanel::DrawText(const char* text, const Vector2D& pos, int color, bool centered) {
    const int x = (int)(_pos.x + pos.x);
    const int y = (int)(_pos.y + pos.y) - (centered ? text_height(GameImplementation()->GetFont())/2 : 0);

    if(centered) {
        textout_centre_ex(GameImplementation()->GetScreenBuffer(), GameImplementation()->GetFont(), text, x, y, color, -1);
    } else {
        textout_ex(GameImplementation()->GetScreenBuffer(), GameImplementation()->GetFont(), text, x, y, color, -1);
    }
}

void AllegroInfoPanel::DrawSlot(const Vector2D& pos, bool centered) {
    BITMAP* slotBitmap = GameImplementation()->GetItemSlotBitmap();
    const int x = (int) (pos.x + _pos.x) - (centered ? slotBitmap->w / 2 : 0);
    const int y = (int) (pos.y + _pos.y) - (centered ? slotBitmap->h / 2 : 0);
    draw_sprite(GameImplementation()->GetScreenBuffer(), slotBitmap, x, y);
}

void AllegroInfoPanel::DrawWeaponIcon(WEAPON_TYPE weaponType, const Vector2D& pos, bool centered) {
    BITMAP* iconBitmap = GameImplementation()->GetWeaponIcon(weaponType);
    const int x = (int) (pos.x + _pos.x) - (centered ? iconBitmap->w / 2 : 0);
    const int y = (int) (pos.y + _pos.y) - (centered ? iconBitmap->h / 2 : 0);
    draw_sprite(GameImplementation()->GetScreenBuffer(), iconBitmap, x, y);
}
