#ifndef Configuration_h
#define	Configuration_h

#include "Game.h"
#include "Player.h"
#include "Util/Colors.h"

class Configuration {
public:
    Configuration();
    virtual ~Configuration();

    virtual void Load(const char* filename) = 0;
    virtual void Save(const char* filename) = 0;

    void ChangePlayerType(int playerIndex);
    bool IsPlayerEnabled(int playerIndex);

    short GetMaxFieldWeaponsCount() { return _maxFieldWeaponsCount; }
    void SetMaxFieldWeaponsCount(short maxFieldWeaponsCount) { _maxFieldWeaponsCount = maxFieldWeaponsCount; }

    PLAYER_COLOR GetPlayerColor(int playerIndex) { return _playerColor[playerIndex]; }
    void SetPlayerColor(int playerIndex, PLAYER_COLOR playerColor) { _playerColor[playerIndex] = playerColor; }

    short GetPlayerKeyCode(int playerIndex, short command) { return _playerKeyCode[playerIndex][command]; }
    void SetPlayerKeyCode(int playerIndex, short command, short playerKeyCode) { _playerKeyCode[playerIndex][command] = playerKeyCode; }

    PLAYER_TYPE GetPlayerType(int playerIndex) { return _playerType[playerIndex]; }
    void SetPlayerType(int playerIndex, PLAYER_TYPE playerType) { _playerType[playerIndex] = playerType; }

    short GetResX() { return _resolutionX; }
    short GetResY() { return _resolutionY; }
    void SetResX(short resX) { _resolutionX = resX; }
    void SetResY(short resY) { _resolutionY = resY; }

    void ChangeResolution();
    void ChangeToLowestResolution();
    const char* GetResString();

    bool IsFullscreen() { return _fullscreen; }
    void SetFullscreen(bool fullscreen) { _fullscreen = fullscreen; }

    bool IsThickLines() { return _thickLines; }
    void SetThickLines(bool thickLines) { _thickLines = thickLines; }

protected:
    int FindResolutionPresetIndex();

protected:
    short _resolutionX;
    short _resolutionY;
    bool _fullscreen;

    short _maxFieldWeaponsCount;
    bool _thickLines; //thick and pseudo-antialiased lines

    PLAYER_TYPE _playerType[MAX_PLAYERS_COUNT]; //human or computer (with different difficulty)
    short _playerKeyCode[MAX_PLAYERS_COUNT][PLAYER_COMMANDS_COUNT];
    PLAYER_COLOR _playerColor[MAX_PLAYERS_COUNT];

    static const int _resPresetCount = 6;
    const char* _resPresetString[_resPresetCount];
    int _resPresetX[_resPresetCount];
    int _resPresetY[_resPresetCount];
};

class AllegroConfiguration : public Configuration {
public:
    virtual void Load(const char* filename);
    virtual void Save(const char* filename);
};

#endif	/* Configuration_h */
