#ifndef Arena_h
#define	Arena_h

#include "Game.h"
#include "Weapons/Weapon.h"

class Game;
class Weapon;

class Arena {
public:
    Arena(Game* game, const Vector2D& pos, const Vector2D& size);
    virtual ~Arena();

    double GetX() { return _pos.x; }
    double GetY() { return _pos.y; }
    const Vector2D& GetPos() { return _pos; }
    void SetX(double x) { _pos.x = x; }
    void SetY(double y) { _pos.y = y; }
    void SetPos(const Vector2D& pos) { _pos = pos; }
    double GetW() { return _size.x; }
    double GetH() { return _size.y; }
    const Vector2D& GetSize() { return _size; }
    void SetH(double h) { _size.x = h; }
    void SetW(double w) { _size.y = w; }
    void SetSize(const Vector2D& size) { _size = size; }

    float GetPan(double xPos) {
        float pan = (xPos/_size.x)*2.0f - 1.0f;
        if(pan < -1.0f) {
            pan = -1.0f;
        } else if(pan > 1.0f) {
            pan = 1.0f;
        }
        return pan*0.75f;
    }

    void SpawnWeapon();

    Weapon* GetActiveWeapon(int index);
    void AddActiveWeapon(Weapon* weapon);
    void RemoveActiveWeapon(Weapon* weapon);
    void DeleteActiveWeapons();
    int GetActiveWeaponsCount();

    Weapon* GetFieldWeapon(short weaponIndex);
    void AddFieldWeapon(Weapon* weapon);
    void RemoveFieldWeapon(Weapon* weapon);
    void DeleteFieldWeapons();
    short GetFieldWeaponCount();

    void Tick();

    virtual void Draw() = 0;
    virtual void DrawLine(const Vector2D &pos1, const Vector2D &pos2, int color) = 0;
    virtual void DrawCircle(const Vector2D &pos, int radius, int color, bool filled) = 0;

    virtual void PlaceLine(const Vector2D &pos1, const Vector2D &pos2, int color) = 0;
    virtual void PlaceCircle(const Vector2D &pos, int radius, int color, bool filled) = 0;
    virtual void PlaceSprite(int spriteID, const Vector2D &pos, bool centered) = 0;

    virtual void Clear() = 0;
    virtual void ClearCircle(const Vector2D &pos, int radius, bool filled) = 0;
    virtual void ClearRect(const Vector2D &pos, const Vector2D &size) = 0;

    virtual double CalcShortestCollisionDist(const Vector2D &fromPos, const Vector2D &scanLine) = 0;
    
protected:
    Game* _game;

    std::vector<Weapon*> _collectableWeapons;
    std::vector<Weapon*> _activeWeapons;

    Vector2D _pos;
    Vector2D _size;
};

class AllegroGame;

class AllegroArena : public Arena {
public:
    AllegroArena(Game* game, const Vector2D& pos, const Vector2D& size);
    virtual ~AllegroArena();

    virtual AllegroGame* GameImplementation() { return (AllegroGame*) _game; }

    virtual void Draw();
    virtual void DrawLine(const Vector2D &pos1, const Vector2D &pos2, int color);
    virtual void DrawCircle(const Vector2D &pos, int radius, int color, bool filled);

    virtual void PlaceLine(const Vector2D &pos1, const Vector2D &pos2, int color);
    virtual void PlaceCircle(const Vector2D &pos, int radius, int color, bool filled);
    virtual void PlaceSprite(int spriteID, const Vector2D &pos, bool centered);

    virtual void Clear();
    virtual void ClearCircle(const Vector2D &pos, int radius, bool filled);
    virtual void ClearRect(const Vector2D &pos, const Vector2D &size);

    virtual double CalcShortestCollisionDist(const Vector2D &fromPos, const Vector2D &scanLine);

protected:
    BITMAP* _wallsBitmap;
};

#endif	/* Arena_h */
