#include <stdio.h>
#include "t3f/t3f.h"
#include "t3f/music.h"
#include "t3net/t3net.h"
#include "main.h"
#include "data.h"
#include "dictionary.h"
#include "player.h"
#include "title.h"
#include "menu_proc.h"
#include "game.h"
#include "tutorial.h"
#include "highscore.h"
#include "leaderboard.h"

void lingo_logic(void)
{
	int letter = 0;
	
	if(!t3f_mouse_button[0])
	{
		lingo_mouse_clicked = 0;
	}
	if(lingo_text_buffer_state == 1)
	{
		letter = t3f_read_key(0);
		if(letter)
		{
			if(letter == '\b' || letter == 127)
			{
				if(lingo_text_buffer_pos > 0)
				{
					al_play_sample(lingo_sample[LINGO_SAMPLE_TYPE], 1.0, 0.5, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);
					lingo_text_buffer_pos--;
					lingo_player[lingo_current_player].name[lingo_text_buffer_pos] = '\0';
				}
			}
			else if(letter == '\r')
			{
				lingo_menu_proc_main_start_game();
			}
			else if(letter >= 32 && letter < 127)
			{
				al_play_sample(lingo_sample[LINGO_SAMPLE_TYPE], 1.0, 0.5, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);
				lingo_player[lingo_current_player].name[lingo_text_buffer_pos] = letter;
				lingo_text_buffer_pos++;
				lingo_player[lingo_current_player].name[lingo_text_buffer_pos] = '\0';
			}
			strcpy(lingo_menu[LINGO_MENU_ENTER_NAME].item[1].name, lingo_player[0].name);
		}
	}
	switch(lingo_state)
	{
		case LINGO_STATE_TITLE:
		{
			lingo_title_logic();
			break;
		}
		case LINGO_STATE_TITLE_TRANSITION_IN:
		{
			lingo_title_transition_in_logic();
			break;
		}
		case LINGO_STATE_TITLE_TRANSITION_OUT:
		{
			lingo_title_transition_out_logic();
			break;
		}
		case LINGO_STATE_GAME:
		{
			lingo_game_logic();
			break;
		}
		case LINGO_STATE_GAME_TRANSITION_IN:
		{
			lingo_game_transition_in_logic();
			break;
		}
		case LINGO_STATE_GAME_TRANSITION_OUT:
		{
			lingo_game_transition_out_logic();
			break;
		}
		case LINGO_STATE_TUTORIAL:
		{
			lingo_tutorial_logic();
			break;
		}
		case LINGO_STATE_TUTORIAL_TRANSITION_IN:
		{
			lingo_tutorial_transition_in_logic();
			break;
		}
		case LINGO_STATE_TUTORIAL_TRANSITION_OUT:
		{
			lingo_tutorial_transition_out_logic();
			break;
		}
		case LINGO_STATE_LEADERBOARD:
		{
			lingo_leaderboard_logic();
			break;
		}
	}
	lingo_logic_counter++;
}

void lingo_draw_text(ALLEGRO_FONT * fp, float x, float y, ALLEGRO_COLOR color, char * text)
{
	al_draw_text(fp, color, x, y, 0, text);
}

void lingo_draw_text_center(ALLEGRO_FONT * fp, float x, float y, ALLEGRO_COLOR color, char * text)
{
	al_draw_text(fp, color, x - al_get_text_width(fp, text) / 2, y, 0, text);
}

void lingo_render(void)
{
	al_hold_bitmap_drawing(true);
	switch(lingo_state)
	{
		case LINGO_STATE_TITLE:
		{
			lingo_title_render();
			break;
		}
		case LINGO_STATE_TITLE_TRANSITION_IN:
		{
			lingo_title_transition_in_render();
			break;
		}
		case LINGO_STATE_TITLE_TRANSITION_OUT:
		{
			lingo_title_transition_out_render();
			break;
		}
		case LINGO_STATE_GAME:
		case LINGO_STATE_GAME_TRANSITION_IN:
		case LINGO_STATE_GAME_TRANSITION_OUT:
		{
			lingo_game_render();
			break;
		}
		case LINGO_STATE_TUTORIAL:
		case LINGO_STATE_TUTORIAL_TRANSITION_IN:
		case LINGO_STATE_TUTORIAL_TRANSITION_OUT:
		{
			lingo_tutorial_render();
			break;
		}
		case LINGO_STATE_LEADERBOARD:
		{
			lingo_leaderboard_render();
			break;
		}
	}
	al_hold_bitmap_drawing(false);
}

void lingo_draw_load_bar(ALLEGRO_BITMAP * bp[3], int step)
{
	int i;
	
	al_copy_transform(&t3f_base_transform, &t3f_current_transform);
	al_use_transform(&t3f_current_transform);
	al_clear_to_color(al_map_rgb(64, 64, 128));
	al_hold_bitmap_drawing(true);
	al_draw_bitmap(lingo_image[LINGO_IMAGE_LOAD], 320 - al_get_bitmap_width(lingo_image[LINGO_IMAGE_LOAD]) / 2, 240 - al_get_bitmap_height(lingo_image[LINGO_IMAGE_LOAD]) / 2, 0);
	for(i = 0; i < step; i++)
	{
//		al_draw_bitmap(bp[2], 319 - i + 2, 300 + 2, 0);
//		al_draw_bitmap(bp[2], 320 + i + 2, 300 + 2, 0);
		al_draw_bitmap(bp[0], 319 - i, 300, 0);
		al_draw_bitmap(bp[0], 320 + i, 300, 0);
	}
//	al_draw_bitmap(bp[2], 319 - step - 1 + 2, 300 + 2, 0);
//	al_draw_bitmap(bp[2], 320 + step + 1 + 2, 300 + 2, 0);
	al_draw_bitmap(bp[1], 319 - step - 1, 300, 0);
	al_draw_bitmap(bp[1], 320 + step + 1, 300, 0);
	al_hold_bitmap_drawing(false);
	al_flip_display();
}

int lingo_initialize(void)
{
	int i;
	ALLEGRO_BITMAP * tempimage;
	ALLEGRO_BITMAP * loadbar[3];
	const char * val = NULL;
		
	if(!t3f_initialize("Word5", 640, 480, 60.0, lingo_logic, lingo_render, T3F_DEFAULT | T3F_USE_MOUSE | T3F_RESIZABLE | T3F_FORCE_ASPECT))
	{
		return 0;
	}

	if(!t3f_locate_resource("data/graphics/loading.png"))
	{
		return 0;
	}
	lingo_image[LINGO_IMAGE_LOAD] = al_load_bitmap("data/graphics/loading.png");
	if(!lingo_image[LINGO_IMAGE_LOAD])
	{
		return 0;
	}
	loadbar[0] = al_load_bitmap("data/graphics/loadbar.png");
	loadbar[1] = al_load_bitmap("data/graphics/loadbaredge.png");
	loadbar[2] = al_load_bitmap("data/graphics/loadbarshadow.png");
	for(i = 0; i < 3; i++)
	{
		if(!loadbar[i])
		{
			return 0;
		}
	}
	
	lingo_draw_load_bar(loadbar, 0);
	
	al_show_mouse_cursor(NULL);
	lingo_draw_load_bar(loadbar, 2);

	lingo_atlas = t3f_create_atlas(T3F_ATLAS_TILES, 256, 64);
	lingo_draw_load_bar(loadbar, 4);
	lingo_image[LINGO_IMAGE_LOGO] = al_load_bitmap("data/graphics/logoimage.png");
	lingo_draw_load_bar(loadbar, 16);
	lingo_image[LINGO_IMAGE_GAMEBOARD] = al_load_bitmap("data/graphics/gameboard.png");
	lingo_draw_load_bar(loadbar, 18);
	tempimage = al_load_bitmap("data/graphics/right.pcx");
	lingo_image[LINGO_IMAGE_RED_SQUARE] = t3f_add_bitmap_to_atlas(lingo_atlas, tempimage);
	al_destroy_bitmap(tempimage);
	lingo_draw_load_bar(loadbar, 20);
	tempimage = al_load_bitmap("data/graphics/right2.pcx");
	lingo_image[LINGO_IMAGE_YELLOW_CIRCLE] = t3f_add_bitmap_to_atlas(lingo_atlas, tempimage);
	al_destroy_bitmap(tempimage);
	lingo_draw_load_bar(loadbar, 22);
	lingo_image[LINGO_IMAGE_BG] = al_load_bitmap("data/graphics/bg.png");
	lingo_draw_load_bar(loadbar, 24);
	lingo_image[LINGO_IMAGE_ICON] = al_load_bitmap("data/graphics/icon.png");
	lingo_draw_load_bar(loadbar, 26);

	lingo_sample[LINGO_SAMPLE_MENU_HOVER] = al_load_sample("data/sounds/hover.ogg");
	lingo_draw_load_bar(loadbar, 28);
	lingo_sample[LINGO_SAMPLE_MENU_CLICK] = al_load_sample("data/sounds/click.ogg");
	lingo_draw_load_bar(loadbar, 30);
	lingo_sample[LINGO_SAMPLE_CORRECT] = al_load_sample("data/sounds/correct.ogg");
	lingo_draw_load_bar(loadbar, 32);
	lingo_sample[LINGO_SAMPLE_INCORRECT] = al_load_sample("data/sounds/incorrect.ogg");
	lingo_draw_load_bar(loadbar, 34);
	lingo_sample[LINGO_SAMPLE_FIRST_LETTER] = al_load_sample("data/sounds/firstletter.ogg");
	lingo_draw_load_bar(loadbar, 36);
	lingo_sample[LINGO_SAMPLE_CORRECT_LETTER] = al_load_sample("data/sounds/correctletter.ogg");
	lingo_draw_load_bar(loadbar, 38);
	lingo_sample[LINGO_SAMPLE_INCORRECT_LETTER] = al_load_sample("data/sounds/incorrectletter.ogg");
	lingo_draw_load_bar(loadbar, 40);
	lingo_sample[LINGO_SAMPLE_YELLOW_LETTER] = al_load_sample("data/sounds/yellowletter.ogg");
	lingo_draw_load_bar(loadbar, 42);
	lingo_sample[LINGO_SAMPLE_HINT] = al_load_sample("data/sounds/hint.ogg");
	lingo_draw_load_bar(loadbar, 44);
	lingo_sample[LINGO_SAMPLE_LOGO] = al_load_sample("data/sounds/logo.ogg");
	lingo_draw_load_bar(loadbar, 46);
	lingo_sample[LINGO_SAMPLE_TYPE] = al_load_sample("data/sounds/type.ogg");
	lingo_draw_load_bar(loadbar, 48);
	lingo_sample[LINGO_SAMPLE_CLOCK] = al_load_sample("data/sounds/clock.ogg");
	lingo_draw_load_bar(loadbar, 50);

	for(i = LINGO_IMAGE_LOGO; i <= LINGO_IMAGE_ICON; i++)
	{
		if(!lingo_image[i])
		{
			return 0;
		}
	}
	al_set_display_icon(t3f_display, lingo_image[LINGO_IMAGE_ICON]);
	lingo_draw_load_bar(loadbar, 52);
	
	lingo_font[LINGO_FONT_SPRINT_10] = t3f_load_font("data/fonts/font_sprint10.pcx");
	lingo_draw_load_bar(loadbar, 54);
	lingo_font[LINGO_FONT_SPRINT_20] = t3f_load_font("data/fonts/font_sprint20.pcx");
	lingo_draw_load_bar(loadbar, 56);
	lingo_font[LINGO_FONT_SPRINT_36] = t3f_load_font("data/fonts/font_sprint36.pcx");
	lingo_draw_load_bar(loadbar, 58);
	lingo_font[LINGO_FONT_ARIAL_36] = t3f_load_font("data/fonts/font_arial36.pcx");
	lingo_draw_load_bar(loadbar, 60);
	for(i = LINGO_FONT_SPRINT_10; i <= LINGO_FONT_ARIAL_36; i++)
	{
		if(!lingo_font[i])
		{
			return 0;
		}
	}
	
	lingo_dictionary = lingo_load_dictionary("data/word5.dictionary");
	if(!lingo_dictionary)
	{
		return 0;
	}
	lingo_load_dictionary_config(lingo_dictionary, "word5.dictionary.cfg");
	lingo_draw_load_bar(loadbar, 62);
	
	lingo_load_score("word5.highscore");
	lingo_draw_load_bar(loadbar, 64);
	
	lingo_title_initialize();
	lingo_draw_load_bar(loadbar, 66);
	
	for(i = 0; i < 3; i++)
	{
		al_destroy_bitmap(loadbar[i]);
	}
	al_destroy_bitmap(lingo_image[LINGO_IMAGE_LOAD]);
	
	val = al_get_config_value(t3f_config, "Game", "Player Name");
	if(val)
	{
		strcpy(lingo_player[0].name, val);
	}
	else
	{
		strcpy(lingo_player[0].name, "Player 1");
	}
	al_set_config_value(t3f_config, "Game", "Player Name", lingo_player[0].name);
	val = al_get_config_value(t3f_config, "Game", "Upload Scores");
	if(val)
	{
		if(!strcmp(val, "Yes"))
		{
			lingo_option[LINGO_OPTION_UPLOAD] = 1;
		}
		else
		{
			lingo_option[LINGO_OPTION_UPLOAD] = 0;
		}
	}
	else
	{
		lingo_option[LINGO_OPTION_UPLOAD] = 1;
		al_set_config_value(t3f_config, "Game", "Upload Scores", lingo_option[LINGO_OPTION_UPLOAD] ? "Yes" : "No");
	}
	
	srand(time(0));
	return 1;
}

int lingo_exit(void)
{
	lingo_save_score("word5.highscore");
	lingo_save_dictionary_config(lingo_dictionary, "word5.dictionary.cfg");
	return 1;
}

int main(int argc, char * argv[])
{
	if(!lingo_initialize())
	{
		return -1;
	}
	t3f_run();
	lingo_exit();
	return 0;
}
