#include <allegro5/allegro5.h>
#ifdef ALLEGRO_WINDOWS
	#include <allegro5/winalleg.h>
	#include <d3d9.h>              
	#include <d3dx9.h>
#endif
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_font.h>
#include <stdio.h>
#include "modules/ocdfont.h"
#include "dictionary.h"

ALLEGRO_DISPLAY * dict_display;
ALLEGRO_TIMER * dict_timer;
ALLEGRO_EVENT_QUEUE * dict_queue;
LINGO_DICTIONARY * dict_dictionary;
ALLEGRO_FONT * dict_font;
int dict_selected_word = 0;

void setSmoothScaling(void)
{
	#ifdef ALLEGRO_WINDOWS
		LPDIRECT3DDEVICE9 dev = al_d3d_get_device(dict_display);

		IDirect3DDevice9_SetSamplerState(dev, 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
	#endif
}

void dict_logic(void)
{
}

void dict_draw_text(ALLEGRO_FONT * fp, float x, float y, ALLEGRO_COLOR color, char * text)
{
	int osrc, odst;
	ALLEGRO_COLOR ocolor;
	
	al_get_blender(&osrc, &odst, &ocolor);
	al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, color);
	al_draw_text(fp, x, y, 0, text);
	al_set_blender(osrc, odst, ocolor);
}

void dict_draw_text_center(ALLEGRO_FONT * fp, float x, float y, ALLEGRO_COLOR color, char * text)
{
	int osrc, odst;
	ALLEGRO_COLOR ocolor;
	
	al_get_blender(&osrc, &odst, &ocolor);
	al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, color);
	al_draw_text(fp, x, y, ALLEGRO_ALIGN_CENTRE, text);
	al_set_blender(osrc, odst, ocolor);
}

void dict_render(void)
{
	ALLEGRO_COLOR col;
	char buf[256];
	
	al_clear_to_color(al_map_rgb(32, 32, 128));
	if(dict_dictionary->useable[dict_selected_word])
	{
		col = al_map_rgba(0, 255, 0, 255);
	}
	else
	{
		col = al_map_rgba(255, 0, 0, 255);
	}
	sprintf(buf, "%s", dict_dictionary->word[dict_selected_word].letter);
	if(dict_dictionary->used[dict_selected_word])
	{
		strcat(buf, "*");
	}
	dict_draw_text(dict_font, 0, 0, col, buf);
	sprintf(buf, "Total Words: %d", dict_dictionary->words);
	dict_draw_text(dict_font, 0, 240, al_map_rgba(255, 255, 255, 255), buf);
	sprintf(buf, "Available Words: %d", dict_dictionary->available_words);
	dict_draw_text(dict_font, 0, 240 + 44, al_map_rgba(255, 255, 255, 255), buf);
	sprintf(buf, "Current Word: %d", dict_selected_word);
	dict_draw_text(dict_font, 0, 240 + 88, al_map_rgba(255, 255, 255, 255), buf);
	al_flip_display();
}

int dict_initialize(void)
{
	al_init();
	al_init_image_addon();
	if(!al_install_keyboard())
	{
		return 0;
	}
	if(!al_install_mouse())
	{
		return 0;
	}
//	al_set_new_display_flags(ALLEGRO_OPENGL);
	dict_display = al_create_display(640, 480);
	if(!dict_display)
	{
		return 0;
	}
	al_show_mouse_cursor();
   
	dict_timer = al_install_timer(1.000 / 60);
	if(!dict_timer)
	{
		return 0;
	}
	dict_queue = al_create_event_queue();
	if(!dict_queue)
	{
		return 0;
	}
	al_register_event_source(dict_queue, al_get_keyboard_event_source());
	al_register_event_source(dict_queue, al_get_mouse_event_source());
	al_register_event_source(dict_queue, (ALLEGRO_EVENT_SOURCE *)dict_display);
	al_register_event_source(dict_queue, (ALLEGRO_EVENT_SOURCE *)dict_timer);
	
	dict_font = ocd_load_font("data/font_sprint20.pcx");
	if(!dict_font)
	{
		return 0;
	}
	
	dict_dictionary = lingo_load_dictionary("word5.dictionary");
	if(!dict_dictionary)
	{
		return 0;
	}
	
	setSmoothScaling();
	return 1;
}

int dict_exit(void)
{
	lingo_save_dictionary(dict_dictionary, "word5.dictionary");
	return 1;
}

int main(int argc, char * argv[])
{
	ALLEGRO_EVENT event;
	int i;
	
	if(!dict_initialize())
	{
		return -1;
	}
	al_start_timer(dict_timer);
	while(1)
	{
		al_wait_for_event(dict_queue, &event);
		switch(event.type)
		{
			/* Was the X button on the window pressed? */
			case ALLEGRO_EVENT_DISPLAY_CLOSE:
			{
				dict_exit();
				return 0;
			}

			/* Was a key pressed? */
			case ALLEGRO_EVENT_KEY_DOWN:
			case ALLEGRO_EVENT_KEY_REPEAT:
			{
				if(event.keyboard.keycode == ALLEGRO_KEY_ESCAPE)
				{
					dict_exit();
					return 0;
				}
				else if(event.keyboard.keycode == ALLEGRO_KEY_DELETE)
				{
					dict_dictionary->useable[dict_selected_word] = 0;
				}
				else if(event.keyboard.keycode == ALLEGRO_KEY_ENTER)
				{
					dict_dictionary->useable[dict_selected_word] = 1;
				}
				else if(event.keyboard.keycode == ALLEGRO_KEY_LEFT)
				{
					dict_selected_word--;
					if(dict_selected_word < 0)
					{
						dict_selected_word = dict_dictionary->words - 1;
					}
				}
				else if(event.keyboard.keycode == ALLEGRO_KEY_RIGHT)
				{
					dict_selected_word++;
					if(dict_selected_word >= dict_dictionary->words - 1)
					{
						dict_selected_word = 0;
					}
				}
				else if(event.keyboard.keycode == ALLEGRO_KEY_1)
				{
					dict_selected_word = lingo_dictionary_choose_word(dict_dictionary);
				}
				else if(event.keyboard.keycode >= ALLEGRO_KEY_A && event.keyboard.keycode <= ALLEGRO_KEY_Z)
				{
					for(i = 0; i < dict_dictionary->words; i++)
					{
						if(dict_dictionary->word[i].letter[0] == event.keyboard.keycode - ALLEGRO_KEY_A + 'A')
						{
							dict_selected_word = i;
							break;
						}
					}
				}
	            break;
			}
/*			case ALLEGRO_EVENT_KEY_REPEAT:
			{
				if(event.keyboard.keycode == ALLEGRO_KEY_DELETE)
				{
					dict_dictionary->useable[dict_selected_word] = 0;
				}
				else if(event.keyboard.keycode == ALLEGRO_KEY_ENTER)
				{
					dict_dictionary->useable[dict_selected_word] = 1;
				}
				else if(event.keyboard.keycode == ALLEGRO_KEY_LEFT)
				{
					dict_selected_word--;
					if(dict_selected_word < 0)
					{
						dict_selected_word = dict_dictionary->words - 1;
					}
				}
				else if(event.keyboard.keycode == ALLEGRO_KEY_RIGHT)
				{
					dict_selected_word++;
					if(dict_selected_word >= dict_dictionary->words - 1)
					{
						dict_selected_word = 0;
					}
				}
				else if(event.keyboard.keycode >= ALLEGRO_KEY_A && event.keyboard.keycode <= ALLEGRO_KEY_Z)
				{
				}
	            break;
			} */
			
			case ALLEGRO_EVENT_MOUSE_BUTTON_DOWN:
			{
				break;
			}

			/* Is it time for the next timer tick? */
			case ALLEGRO_EVENT_TIMER:
			{
				/* logic goes here */
				dict_logic();
				dict_render();
				break;
			}
		}
	}
	dict_exit();
	return 0;
}
END_OF_MAIN()
