/***************************************************************************
 *
 * cpwin_ss.c
 * ChromaPlas Windows specific screensaver code
 * Turns Chromaplas into a Windows screensaver that uses Allegro.
 *
 * By Andrei Ellman
 *
 **************************************************************************/






/****************************************************************************
 Includes
 */



#include <stdio.h>

#include <allegro.h>
#include <winalleg.h>

#include <shellapi.h>	/* Needed for Dragging filenames onto the dialog ( DragQueryFile() ) */

#include "aeglobal.h"

#include "cpglobal.h"

#include "cpsttngs.h"

#include "cpgfx.h"

#include "cpconfig.h"

#include "cpprglp.h"

// ?: Is #include "cpwin_.h" needed?

#include "cpwin_ss.h"

#include "cpwinrsc.rh"



/****************************************************************************
 Local Types
 */


/****************************************************************************
 Global Prototypes
 */


/****************************************************************************
 Local (Static) Prototypes
 */


/****************************************************************************
 Local Defines
 */

#define MAX_NUMERIC_EDIT_LENGTH 12

#define CPPREVIEWNUMMSECPERTICK	15 // Is 15 a good value? (15 msecs 0.015 seca = 66.666hz) How about 1000/60 ? NB Minimum value for SetTimer() is 10.


/****************************************************************************
 Local Macros
 */


/****************************************************************************
 Global Variables (across program)
 */


/****************************************************************************
 Local (static) Global Variables
 */

static GFX_MODE_LIST *g_gmlpModes;

static HINSTANCE g_hInstance;
static HINSTANCE g_hPrevInstance;

static CpChromaPlasSettings g_cpsOldSettings; /* A backup of the old settings just in case we cancel */




/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                          Various ancillary functions.

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */


void
cpSetGlobalInstanceHandles_Win_SS(HINSTANCE hInstance, HINSTANCE hPrevInstance)
{
	g_hInstance = hInstance;
	g_hPrevInstance = hPrevInstance;
}



// TODO: Do we need to filter out rez's not available with the current BPP?
// ie, instead, relying on having the size combo filled according to the BPP,
// we change the BPP combo if size not available for the current BPP. Ditto for vice versa.

// \sa _cpSetScreenRezComboSize
static int
_cpFillScreenRezSizeCombo(HWND hwndDlg, int nBPP)
{
	int nI;	/* Loop counter */
	HWND hCtrl;

	char szTmpString[256];

	GFX_MODE *mpMode = g_gmlpModes->mode;

	int nNumEntriesInList = 0;

	// If using Page-flipping, would need a doubly-large screenbuffer.
	// Is there a way to find out which modes can be page-flipped? (we would need double the VRAM the mode requires)


	hCtrl = GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_XY);

	SendMessage(hCtrl, CB_RESETCONTENT, 0, 0);	/* Make sure we start afresh */

	for(nI=0;nI<g_gmlpModes->num_modes;nI++,mpMode++)
	{

		#ifdef _DEBUG
		if(mpMode->width==0 && mpMode->height==0 && mpMode->bpp==0)
		{
			TRACE("Insanity: g_gmlpModes->num_modes inconsistent with number of modes in g_gmlpModes->mode\n");
		}
		#endif

		if(mpMode->bpp == nBPP)
		{
			sprintf(szTmpString,"%d * %d", mpMode->width, mpMode->height);

			/* Add the string to the combobox */
			SendMessage(hCtrl, CB_ADDSTRING, 0, (LPARAM) szTmpString);

			/* Which entry in g_gmlpModes->mode[] is this graphics mode? (nI==mode-ID) */
			SendMessage(hCtrl, CB_SETITEMDATA, (WPARAM) nNumEntriesInList++, (LPARAM) (DWORD) nI);
		}

	}

	return nNumEntriesInList;
}



// \sa _cpSetScreenRezComboBPP()
static int
_cpFillScreenRezBPPCombo(HWND hwndDlg)
{
	int nI, nJ;	/* Loop counters */
	HWND hCtrl;

	char szTmpString[256];

	GFX_MODE *mpMode = g_gmlpModes->mode;

	int nNumEntriesInList = 0;

	// If using Page-flipping, would need a doubly-large screenbuffer.
	// Is there a way to find out which modes can be page-flipped? (we would need double the VRAM the mode requires)


	hCtrl = GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_COLOURDEPTH);

	SendMessage(hCtrl, CB_RESETCONTENT, 0, 0);	/* Make sure we start afresh */

	for(nI=0;nI<g_gmlpModes->num_modes;nI++,mpMode++)
	{

		#ifdef _DEBUG
		if(mpMode->width==0 && mpMode->height==0 && mpMode->bpp==0)
		{
			TRACE("Insanity: g_gmlpModes->num_modes inconsistent with number of modes in g_gmlpModes->mode\n");
		}
		#endif

		/* check to see if the BPP of this mode has already been placed in the list */
		for(nJ=0;nJ<nNumEntriesInList;nJ++)
		{
			if(SendMessage(hCtrl, CB_GETITEMDATA, nJ, 0) == mpMode->bpp)
			{
				break;	/* We found that BPP already mentioned in the list */
			}
		}


		/* If not found, then add */
		if(nJ == nNumEntriesInList)
		{
			if(cpBPPIsAllowed(mpMode->bpp))
			{
				sprintf(szTmpString,"%d", mpMode->bpp);

				/* Add the string to the combobox */
				SendMessage(hCtrl, CB_ADDSTRING, 0, (LPARAM) szTmpString);

				/* Remember the value of the mode's BPP? */
				SendMessage(hCtrl, CB_SETITEMDATA, (WPARAM) nNumEntriesInList++, (LPARAM) (DWORD) mpMode->bpp);
			}
		}


		// ?: Do we need to numercally sort the list of BPPs?


	}

	return nNumEntriesInList;

}




static int
_cpGetModeIDFromModeSizeInComboBox(HWND hCtrl, int nWidth, int nHeight)
{
	int nJ;

	int nNumEntriesInList = SendMessage(hCtrl, CB_GETCOUNT, 0, 0);

	/* Search the entries in the combo-box for the mode we just found */
	for(nJ=0;nJ<nNumEntriesInList;nJ++)
	{
		int nModeID = (int) SendMessage(hCtrl, CB_GETITEMDATA, nJ, 0);
		GFX_MODE *mpMode = &g_gmlpModes->mode[nModeID];

		/* If the mode is in the combo-box, it means the mode's BPP is what we're looking for, as we specified the BPP as we were filling the combo */
		if(mpMode->width == nWidth && mpMode->height == nHeight)
		{
			return nModeID;
		}

	}

	return -1;	/* Not found */

}



// _cpFillScreenRezSizeCombo()
/* Sets the screen resolution size combo to the mode identified with nModeID */
static AeBool
_cpSetScreenRezComboSize(HWND hCtrl, int nModeID)
{
	int nJ;

	int nNumEntriesInList = SendMessage(hCtrl, CB_GETCOUNT, 0, 0);

	/* Search the entries in the combo-box for the mode-ID */
	for(nJ=0;nJ<nNumEntriesInList;nJ++)
	{
		//int nMID_DEBUG = SendMessage(hCtrl, CB_GETITEMDATA, nJ, 0);
		int nListModeID = (int) SendMessage(hCtrl, CB_GETITEMDATA, nJ, 0);
		if(nListModeID == nModeID)
		{
			/* We found the mode in the combo - set the combobox with this index */
			SendMessage(hCtrl, CB_SETCURSEL, nJ, 0);

			return TRUE;
		}
	}

	return FALSE;	/* The size-value was not found in the Combobox's list */
}



// \sa _cpFillScreenRezBPPCombo()
/* Sets the bpp combo to the bpp identified with nBPP */
static AeBool
_cpSetScreenRezComboBPP(HWND hCtrl, int nBPP)
{
	int nJ;

	int nNumEntriesInList = SendMessage(hCtrl, CB_GETCOUNT, 0, 0);

	/* Search the entries in the combo-box for the BPP */
	for(nJ=0;nJ<nNumEntriesInList;nJ++)
	{
		if(SendMessage(hCtrl, CB_GETITEMDATA, nJ, 0) == nBPP)
		{
			/* We found the mode in the combo - set the combobox with this index */
			SendMessage(hCtrl, CB_SETCURSEL, nJ, 0);
			return TRUE;	// TODO: if multiple graphics drivers, there may be multipe versions of this mode.
		}

	}

	return FALSE;	/* The BPP-value was not found in the Combobox's list */
}



static AeBool
_cpSetScreenRezCombos(HWND hwndDlg, int nWidth, int nHeight, int nBPP)
{
	int nI;
	HWND hCtrl;

	GFX_MODE *mpMode = g_gmlpModes->mode;

	/* Search the list of graphics modes */
	for(nI=0;nI<g_gmlpModes->num_modes;nI++,mpMode++)
	{
		if((mpMode->bpp==24 && G_cps.bDisable24bpp) || (mpMode->bpp==8 && G_cps.bDisable8bpp))
		{
			continue;	/* Prevent unwanted BPPs from appearing in the search. */
		}

		if(mpMode->width == nWidth && mpMode->height == nHeight && mpMode->bpp == nBPP)
		{
			/* We found the mode */
			hCtrl = GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_XY);

			if(_cpSetScreenRezComboSize(hCtrl,nI))
			{
				/* And now, set the BPP combo box */
				hCtrl = GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_COLOURDEPTH);
				if(_cpSetScreenRezComboBPP(hCtrl,nBPP))
				{
					return TRUE;
				}
				else
				{
					ASSERT(FALSE);	/* If the mode exists, we must have already filled it's BPP entry in the combobox */
				}

			}
			else
			{
				ASSERT(FALSE);	/* If the mode exists, we must have already filled it's size entry in the combobox */
			}

		}


	}

	return FALSE;	/* No mode matching the criteria found */

}



AeBool
cpGetImageFilenameFromWinFileSelect(char *szFileName, HWND hwndDlg)
{
	OPENFILENAME ofn;
	char szFilterList[512];
	char *szFilterListNextString = szFilterList;



	if(!exists(szFileName))
	{
		/* If the file does not exist, for now, get the file-selector to start in the same directory as the executable with the default filename */
		char szFilePath[CPPATHSTRINGSIZE];

		if(GetModuleFileName(NULL, szFilePath, sizeof(szFilePath))==0)
		{
			// WARNING: GetModuleFileName() may return a string in a differnt format than ustrzcpy() accepts.
			ustrzcpy(szFilePath, CPPATHSTRINGSIZE, empty_string);	/* Empty the filename string */
		}

		replace_filename(szFileName, szFilePath, CPDEFAULT_IMAGEFILENAME, CPPATHSTRINGSIZE);
	}




	/* Work out list of extensions of files we're going to use */
	// lower case so they fit in the fileselect types combo?
	memset(szFilterList, 0, sizeof(szFilterList));
	strcpy(szFilterListNextString,"Image Files (*.BMP,*.PCX,*.LBM,*.TGA");
	#ifndef CP_NO_JPEG
	strcat(szFilterListNextString,",*.JPEG,*.JPG,*.JPE");
	#endif
	#ifndef CP_NO_PNG
	strcat(szFilterListNextString,",*.PNG");
	#endif
	strcat(szFilterListNextString,")");
	szFilterListNextString = szFilterListNextString+strlen(szFilterListNextString)+1;
	strcpy(szFilterListNextString,"*.BMP;*.PCX;*.LBM;*.TGA");
	#ifndef CP_NO_JPEG
	strcat(szFilterListNextString,";*.JPG;*.JPE;*.JPEG");
	#endif
	#ifndef CP_NO_PNG
	strcat(szFilterListNextString,";*.PNG");
	#endif



	/* OK. Let's fill out this monstrossity of a OPENFILENAME struct */

	memset(&ofn, 0, sizeof(OPENFILENAME));	/* Too lazy to set all nonused members to NULL */

	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= hwndDlg;
	// ofn.hInstance	= g_hInstance;//?
	ofn.lpstrFilter		= szFilterList;
	ofn.nFilterIndex	= 1;

	ofn.lpstrFile		= szFileName;	// This can also contain the file name used to initialize the File Name edit control.
	ofn.nMaxFile		= MAX_PATH;

	//lpstrFileTitle
	//nMaxFileTitle

	ofn.lpstrTitle		= "Choose an image to apply the plasma effect on";

	ofn.lpstrInitialDir = NULL;	// if NULL, gets from lpstrFile

	ofn.Flags = OFN_HIDEREADONLY	/* OFN_NOCHANGEDIR */	/* OFN_DONTADDTORECENT W2Konly? */;


	/* Pheee'eewww, that was a biiig one! */

	return GetOpenFileName(&ofn);

}




/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                          Dialog box callbacks.

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */



/* dialog procedure for the 'About' dialog */
BOOL CALLBACK
cpAboutDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			// TODO: Print some settings about the Allegro DLL version, Windows version, etc.
			// eg: "Some funky futuristic version of Windows with all the bugs fixed (yeah right)"

			// TODO: Compiler verson (GCC x.xx, MSVC x.xx, etc).

			char szTemp[255];

			sprintf(szTemp, "Built using Allegro %s", ALLEGRO_VERSION_STR);
			SendMessage(GetDlgItem(hwndDlg, IDC_TEXT_ALLEGROVER), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTemp));

			sprintf(szTemp, "with the %s build", ALLEGRO_PLATFORM_STR);
#ifdef ALLEGRO_STATICLINK
			strcat(szTemp, " (Static-build)");
#endif
			SendMessage(GetDlgItem(hwndDlg, IDC_TEXT_BUILD), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTemp));

#ifdef CP_NO_JPEG
			strcpy(szTemp, "JPEG support: DISABLED");
			SendMessage(GetDlgItem(hwndDlg, IDC_TEXT_JPEGSUPPORT), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTemp));
#endif

#ifdef CP_NO_PNG
			strcpy(szTemp, "PNG support: DISABLED");
			SendMessage(GetDlgItem(hwndDlg, IDC_TEXT_PNGSUPPORT), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTemp));
#endif

			sprintf(szTemp, "INI settings name: %s", G_cps.szConfigSettingsName);
			SendMessage(GetDlgItem(hwndDlg, IDC_TEXT_SETTINGSNAME), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTemp));
			

			return TRUE;
		}


		case WM_DESTROY:
		{
			return TRUE;
		}


		case WM_COMMAND:
		{

			switch (LOWORD(wParam))
			{

				case IDABOUTOK:
				{
					EndDialog(hwndDlg,1);
					return TRUE;
				}

			}
		} break;


		case WM_CLOSE:
		{
			/* Make sure closing this window has the same effect as pressing 'OK' */
			PostMessage(hwndDlg,WM_COMMAND,IDABOUTOK,0);
			return TRUE;
		}

	}

   return FALSE;
}



void
_cpDoTest(HWND hwndDlg)
{
	// ?: Do we need to temporarily change _screensaver_policy so the SS does not pop up whilst testing?
	
	// Pass in FALSE for bLoadAppSettings so that we use the dialog settings instead of what's in the INI file.
	// The Allegro-engine config is not remembered from when it was loaed in cpDoSettings - hence passing in TRUE for bLoadAllegroSettings
	// Currently, we are not using any Allegro-engine settings in the dialog, but if we do (eg. _wait_for_vsync), is it possible to copy them once the INI has been loaded?
	if(cpDoProgram(FALSE, TRUE, FALSE)==-1)
	{
		MessageBox(hwndDlg, "Something went wrong while testing the screensaver", "Eek!", 0);
		// ?: Pass out a value?
	}
}


// ?: Move to a generic UI file?
static AeBool
_cpImageTypeGreysOutZoomCheckbox(void)
{
	switch(G_cps.isImgSource)
	{
		case cpIMGTYPE_NONE:
		case cpIMGTYPE_BUILTIN:
		{
			return TRUE;
		}
		break;

		default:
		{
			return FALSE;
		}
	}
}

// TODO: More functions like the above.






/* All controls who'se enabledness is depndant on the funky palette are enabled/diasbled here. */
static void
_cpGreyOutUnusedFunkyPaletteControls(HWND hwndDlg)
{
	AeBool bEnable = (G_cps.isImgSource == cpIMGTYPE_NONE) && G_cps.psPaletteSource==cpPALETTESOURCE_FUNKYPALETTEEFFECT;

	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_RGB),bEnable);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HSV),bEnable);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HLS),bEnable);	

	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_GLOBAL_SPEED_EDIT),bEnable);	// ?: Should this one's enabledness also depend on other palette efffects? If using no palette effect, we might want to colourcycle, but OTTOH this can be done with the plasma-roll.
}


/* All controls who'se enabledness is depndant on the custom/external palette are enabled/diasbled here. */
static void
_cpGreyOutUnusedCustomPaletteControls(HWND hwndDlg)
{
	AeBool bEnable = (G_cps.isImgSource == cpIMGTYPE_NONE) && G_cps.psPaletteSource==cpPALETTESOURCE_EXTERNALPALETTE;

	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOURS_CUSTOMPALETTE_PALETTEFILENAMEEDIT),bEnable);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOURS_CUSTOMPALETTE_PALETTEFILENAMEBROWSEBUTTON),bEnable);
}



static void
_cpGreyOutUnusedPaletteSourceControls(HWND hwndDlg)
{
	_cpGreyOutUnusedFunkyPaletteControls(hwndDlg);
	_cpGreyOutUnusedCustomPaletteControls(hwndDlg);
}


/* All controls who'se enabledness is depndant on whether or not plasma-colours are being used (G_cps.isImgSource==cpIMGTYPE_NONE) are enabled/diasbled here. */
static void
_cpGreyOutUnusedPlasmaColoursControls(HWND hwndDlg)
{
	AeBool bEnable = (G_cps.isImgSource == cpIMGTYPE_NONE);

	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_SIMPLEPALETTE),bEnable);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_FUNKYPALETTE),bEnable);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_CUSTOMPALETTE),bEnable);

	_cpGreyOutUnusedPaletteSourceControls(hwndDlg);
}


/* Grey-out the unused file-related widgets in the settings-dialog */
/* All controls who'se enabledness is depndant on G_cps.isImgSource==cpIMGTYPE_FILE are enabled/diasbled here. */
static void
_cpGreyOutUnusedFileControls(HWND hwndDlg)
{
	AeBool bEnable = (G_cps.isImgSource == cpIMGTYPE_FILE);

	EnableWindow(GetDlgItem(hwndDlg, IDC_IMAGETYPE_FILENAMEEDIT),bEnable);
	EnableWindow(GetDlgItem(hwndDlg, IDC_IMAGETYPE_FILENAMEBROWSEBUTTON),bEnable);
}


/* All controls who'se enabledness is depndant on G_cps.isImgSource are enabled/diasbled here. */
static void
_cpGreyOutUnusedImageSourceControls(HWND hwndDlg)
{
	/* Controls associated with cpIMGTYPE_NONE */
	_cpGreyOutUnusedPlasmaColoursControls(hwndDlg);

	/* Controls associated with cpIMGTYPE_FILE */
	_cpGreyOutUnusedFileControls(hwndDlg);
}



/* All controls who'se enabledness is depndant on G_cps.irsImgResSource == cpIMGRESSOURCE_CUSTOM are enabled/diasbled here. */
static void
_cpGreyOutUnusedResolutionControls(HWND hwndDlg)
{
	AeBool bEnable = (G_cps.irsImgResSource == cpIMGRESSOURCE_CUSTOM);

	EnableWindow(GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_XY),bEnable);
	EnableWindow(GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_COLOURDEPTH),bEnable);
}





// ?: Should this not be called from _cpGreyOutUnusedZoomingControlsZoomOptions() as not directly related to zooming.
static void
_cpGreyOutUnusedExpandPlasmaToFillScreenControls(HWND hwndDlg)
{
	AeBool bEnable = !_cpImageTypeGreysOutZoomCheckbox() && (!G_cps.bZoom || G_cps.bZoomAspectPreserve);

	EnableWindow(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_EXPANDPLASMATOFILLSCREEN),bEnable);
}


/* Enable controls depending on status of 'Zoom' option */
static void
_cpGreyOutUnusedZoomingControlsZoomOptions(HWND hwndDlg)
{
	AeBool bEnable = G_cps.bZoom && !_cpImageTypeGreysOutZoomCheckbox();

	EnableWindow(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_ZOOM_ASPECTPRESERVE),bEnable);

	_cpGreyOutUnusedExpandPlasmaToFillScreenControls(hwndDlg);
}

/* Enable the zoom control and controls depending on status of 'Zoom' option depending on whether zooming is relevant for a particular image-type. */
static void
_cpGreyOutUnusedZoomingControls(HWND hwndDlg)
{
	AeBool bEnable = !_cpImageTypeGreysOutZoomCheckbox();

	EnableWindow(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_ZOOM),bEnable);
	_cpGreyOutUnusedZoomingControlsZoomOptions(hwndDlg);
}




/* Disable unused plasma-intensity */
// ?: Would we want intensity for the funky palette effect?
// \sa _cpUseIntensityAndBounceOnPlasma() etc.
static void
_cpGreyOutUnusedPlasmaIntensityControls(HWND hwndDlg)
{
	AeBool bEnable = !(G_cps.bFullIntensityHueWrap || (G_cps.isImgSource == cpIMGTYPE_NONE && G_cps.psPaletteSource!=cpPALETTESOURCE_NONE));
	// Idea: Could use intensity with funky palette effect or custom palette - it would just go from dark to full-brightness.

	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMA_INTENSITY_EDIT),bEnable);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMA_INTENSITY_RISE_TIME_EDIT),bEnable);
}


/* Disable unused plasma controls */
static void
_cpGreyOutUnusedPlasmaControls(HWND hwndDlg)
{
	/* Don't allow the enabledness of the full intensity wrap when funky plaette or custom palette is enabled (these imply full intensity wrap) */
	// ?: Would we want to use funky palette and no full intensity wrap?

	AeBool bEnable = !(G_cps.isImgSource == cpIMGTYPE_NONE && G_cps.psPaletteSource!=cpPALETTESOURCE_NONE);

	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASMA_CHECK_FULLINTENSITYWRAP),bEnable);

	_cpGreyOutUnusedPlasmaIntensityControls(hwndDlg);
}


/* Grey-out the unused plasma-fx colour-space controls in the settings-dialog */
static void
_cpGreyOutUnusedPlasFXCSControls(HWND hwndDlg)
{
	/* Grey out all checkboxes except for those belonging to the currently selected colourspace */
	/* if(G_cps.isImgSource==cpIMGTYPE_NONE) it means we're greying them all out */


	AeBool bEnableRGB = (G_cps.csColourSpaceToUse==cpCOLOURSPACE_RGB && G_cps.isImgSource!=cpIMGTYPE_NONE);
	AeBool bEnableHSV = (G_cps.csColourSpaceToUse==cpCOLOURSPACE_HSV && G_cps.isImgSource!=cpIMGTYPE_NONE);
	AeBool bEnableHLS = (G_cps.csColourSpaceToUse==cpCOLOURSPACE_HLS && G_cps.isImgSource!=cpIMGTYPE_NONE);
	AeBool bEnableColourSpaceRadios = (G_cps.isImgSource!=cpIMGTYPE_NONE);

	/* Make sure the colourspace checkboxes are greyed out except for the group selected by the colour-space radios unless(G_cps.isImgSource==cpIMGTYPE_NONE) */
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_R),bEnableRGB);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_G),bEnableRGB);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_B),bEnableRGB);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_H),bEnableHSV);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_S),bEnableHSV);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_V),bEnableHSV);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_H),bEnableHLS);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_L),bEnableHLS);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_S),bEnableHLS);

	/* Make sure the colour-space radios are greyed out if(G_cps.isImgSource==cpIMGTYPE_NONE) */
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_RADIO_RGB),bEnableColourSpaceRadios);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_RADIO_HSV),bEnableColourSpaceRadios);
	EnableWindow(GetDlgItem(hwndDlg, IDC_PLASFX_RADIO_HLS),bEnableColourSpaceRadios);
}





void
cpSettingsDlgSetToCurrentSettings(HWND hwndDlg)
{
	char szTmpNumString[MAX_NUMERIC_EDIT_LENGTH+1];

	/* Grab a handle to commonly-used controls */
	HWND hImgTypeFileNameEdit = GetDlgItem(hwndDlg, IDC_IMAGETYPE_FILENAMEEDIT);
	HWND hPlasmacoloursCustompaletteFileNameEdit = GetDlgItem(hwndDlg, IDC_PLASMACOLOURS_CUSTOMPALETTE_PALETTEFILENAMEEDIT);




	/* Fill out the previous values and grey-out the inappropriate choices */

	// NOTE: If doing a preview, then if things like the plasma-settings change, we will have to re-do the pre-calculated tabs.



	/* Init Global settings */

	/* Global Speed */
	sprintf(szTmpNumString, "%f", G_cps.nGlobalSpeed);
	SendMessage(GetDlgItem(hwndDlg, IDC_GLOBAL_SPEED_EDIT), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTmpNumString));
	SendMessage(GetDlgItem(hwndDlg, IDC_GLOBAL_SPEED_EDIT), EM_LIMITTEXT, MAX_NUMERIC_EDIT_LENGTH, 0);



	/* Init Image settings */


	/* Image source radios */

	switch(G_cps.isImgSource)
	{
		case cpIMGTYPE_NONE:
		{
			CheckRadioButton(hwndDlg, IDC_IMAGETYPE_RADIO_NOIMAGE, IDC_IMAGETYPE_RADIO_FILE, IDC_IMAGETYPE_RADIO_NOIMAGE);
		}
		break;

		case cpIMGTYPE_BUILTIN:
		{
			CheckRadioButton(hwndDlg, IDC_IMAGETYPE_RADIO_NOIMAGE, IDC_IMAGETYPE_RADIO_FILE, IDC_IMAGETYPE_RADIO_BUILTIN);
		}
		break;

		case cpIMGTYPE_DESKTOP:
		{
			CheckRadioButton(hwndDlg, IDC_IMAGETYPE_RADIO_NOIMAGE, IDC_IMAGETYPE_RADIO_FILE, IDC_IMAGETYPE_RADIO_DESKTOP);
		}
		break;

		case cpIMGTYPE_DESKTOP_WALLPAPER:
		{
			CheckRadioButton(hwndDlg, IDC_IMAGETYPE_RADIO_NOIMAGE, IDC_IMAGETYPE_RADIO_FILE, IDC_IMAGETYPE_RADIO_DESKTOPWALLPAPER);
		}
		break;

		case cpIMGTYPE_FILE:
		{
			CheckRadioButton(hwndDlg, IDC_IMAGETYPE_RADIO_NOIMAGE, IDC_IMAGETYPE_RADIO_FILE, IDC_IMAGETYPE_RADIO_FILE);
		}
		break;

		default:
		{
			TRACE("Invalid image type (how could this be, we checked when parsing the input)");
//					set to CPDEFAULT_IMAGESOURCE (or whatever default is)
		}
		break;
	}

	_cpGreyOutUnusedImageSourceControls(hwndDlg);
	_cpGreyOutUnusedPlasmaControls(hwndDlg);
	_cpGreyOutUnusedZoomingControls(hwndDlg);
	_cpGreyOutUnusedPlasFXCSControls(hwndDlg);




	/* Image filename */

	// DragAcceptFiles(hImgTypeFileNameEdit, TRUE);

	// WARNING: WM_SETTEXT may require the string to be in a differnt format than  G_cps.szFileName .
	SendMessage(hImgTypeFileNameEdit, WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) G_cps.szFileName));
	// TODO: If filename surrounded by ""'s, remove them.




	/* Init Rendering settings */

	/* Image resolution source */
	switch(G_cps.irsImgResSource)
	{
		case cpIMGRESSOURCE_IMAGE:
		{
			CheckRadioButton(hwndDlg, IDC_RENDERING_RADIO_IMAGE, IDC_RENDERING_RADIO_CUSTOM, IDC_RENDERING_RADIO_IMAGE);
		}
		break;

		case cpIMGRESSOURCE_CUSTOM:
		{
			CheckRadioButton(hwndDlg, IDC_RENDERING_RADIO_IMAGE, IDC_RENDERING_RADIO_CUSTOM, IDC_RENDERING_RADIO_CUSTOM);
		}
		break;

		default:
		{
			TRACE("Invalid image reolution source /* (how could this be? We checked when parsing the input) */");
//					set to CPDEFAULT_IMGRESSOURCE
		}
		break;
	}
	_cpGreyOutUnusedResolutionControls(hwndDlg);



	/* Screen custom-resolution */
	if(_cpFillScreenRezSizeCombo(hwndDlg, G_cps.nBPP) == 0)
	{
		int nBPPIndex;

		/* EEK: BPP specified in G_cps.nBPP not valid (ie. there were no modes with that BPP) */
		TRACE("Warning: No mode available with the specified BPP (%d).", G_cps.nBPP);

		/* Let's find a supported BPP */

		for(nBPPIndex=0; (G_cps.nBPP = cpGetAllowedBPP(nBPPIndex)) != -1; nBPPIndex++)
		{
			if((G_cps.nBPP==24 && G_cps.bDisable24bpp) || (G_cps.nBPP==8 && G_cps.bDisable8bpp))
			{
				continue;	/* Prevent unwanted BPPs from being tested. */
			}

			if(_cpFillScreenRezSizeCombo(hwndDlg, G_cps.nBPP) != 0)
			{
				TRACE(" Using the following BPP instead (%d).\n", G_cps.nBPP);
				break;	/* We have found a BPP that we can support */
			}
		}

		ASSERT(G_cps.nBPP != -1);	/* No possible BPP is supported */
		TRACE(" In fact, no BPP is available (this cannot be!).");	// However, what if bDisable8bpp or bDisable24bpp ?
	}

	if(_cpFillScreenRezBPPCombo(hwndDlg)==0)
	{
		ASSERT(FALSE);	/* There are no available BPP's */
	}


	/* Attempt to set the curent mode on the screen rez combos (rez and bpp) */
	if(!_cpSetScreenRezCombos(hwndDlg, G_cps.nWidth, G_cps.nHeight, G_cps.nBPP))
	{
		/* The passed in rez is unavailable so we must find another */
		long nModeID;
		GFX_MODE *mpMode;
		HWND hCtrl;

		/* Try the default rez's size with currently selected BPP. */
		if(!_cpSetScreenRezCombos(hwndDlg, CPDEFAULT_IMGCUSTOMWIDTH, CPDEFAULT_IMGCUSTOMHEIGHT, G_cps.nBPP))
		{
			/* If default rez not available, use first mode on list of modes with the currently selected BPP */

			int nI;

			int nWidth=0;
			int nHeight=0;

			mpMode = g_gmlpModes->mode;

			for(nI=0;nI<g_gmlpModes->num_modes;nI++,mpMode++)
			{
				if((mpMode->bpp==24 && G_cps.bDisable24bpp) || (mpMode->bpp==8 && G_cps.bDisable8bpp))
				{
					continue;	/* Prevent unwanted BPPs from appearing in the search. */
				}

				if(mpMode->bpp == G_cps.nBPP)	// ?: Merge with above if()?
				{
					/* We found a mode of the correct BPP */
					nWidth = mpMode->width;
					nHeight = mpMode->height;
					break;
				}
			}

			/* If the screen rez size combo could be filled for current BPP, it means there must be at least one mode with this BPP ... unless this BPP has been disabled. */
			if(nI==g_gmlpModes->num_modes)
			{

				// ASSERT(G_cps.bDisable24bpp || G_cps.bDisable8bpp);	/* nI==g_gmlpModes->num_modes Should only happen if chosen bpp was disabled. (?: What if nonsensical BPP in INI? If we do sanity checks on reading the INI, we can uncomment this ASSERT) */

				/* Try the current rez's size with the default BPP. */
				_cpFillScreenRezSizeCombo(hwndDlg, CPDEFAULT_IMGCUSTOMBPP);	// Done so that _cpSetScreenRezCombos() returns one with the appropriate mode-ID for this BPP.
				if(!_cpSetScreenRezCombos(hwndDlg, G_cps.nWidth, G_cps.nHeight, CPDEFAULT_IMGCUSTOMBPP))
				{
					/* Do another search but this time, don't restrict it to G_cps.nBPP */
					// ?: Should I do a search with G_cps.nWidth, G_cps.nHeight first?
					mpMode = g_gmlpModes->mode;

					for(nI=0;nI<g_gmlpModes->num_modes;nI++,mpMode++)
					{
						if((mpMode->bpp==24 && G_cps.bDisable24bpp) || (mpMode->bpp==8 && G_cps.bDisable8bpp))
						{
							continue;	/* Prevent unwanted BPPs from appearing in the search. */
						}

						/* Just try the first mode we find that is not disabled. */
						_cpFillScreenRezSizeCombo(hwndDlg, mpMode->bpp);	// Done so that _cpSetScreenRezCombos() returns one with the appropriate mode-ID for this BPP.
						if(!_cpSetScreenRezCombos(hwndDlg, mpMode->width, mpMode->height, mpMode->bpp))
						{
							ASSERT(FALSE);	/* This mode should have been made available on the combo. */
						}
						else
						{	
							break;
						}
					}
					if(nI==g_gmlpModes->num_modes)
					{
						/* There does not exist a mode that meets our criteria. Give up.  */
						MessageBox(hwndDlg, "There are no available graphics modes to chose from!\nTry and make sure no colour-depths are disabled in the INI file. If that does not help, you'll just have to come to terms with the fact that CromaPlas is a graphical imposibility on this machine.", "Gah!", MB_ICONERROR);
					}
				}
			}
			else
			{
				/* Now we have this mode with G_cps.nBPP, select it on the combo. */
				if(!_cpSetScreenRezCombos(hwndDlg, nWidth, nHeight, G_cps.nBPP))
				{
					ASSERT(FALSE);	/* This mode should have been made available on the combo. */
				}
			}
		}


		/* Adjust G_cps's mode to the newly selected mode */
		hCtrl = GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_XY);
		nModeID = SendMessage(hCtrl, CB_GETITEMDATA, SendMessage(hCtrl, CB_GETCURSEL, 0, 0), 0);
		mpMode = &g_gmlpModes->mode[nModeID];

		G_cps.nWidth = mpMode->width;
		G_cps.nHeight = mpMode->height;
		G_cps.nBPP = mpMode->bpp;

	}

	// TODO: Sanity-Checks to make sure the G_cps mode exists, and for that matter, any other displayed mode.




	// If we ever make the rendering-type (DB, PF, TB etc.) an option, do it here.
	//
	// _cpGreyOutUnusedRenderingTypeControls(hwndDlg);


	/* Zoom checkbox */
	SendMessage(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_ZOOM), BM_SETCHECK, (G_cps.bZoom?BST_CHECKED:BST_UNCHECKED), 0);

	/* Zoom aspect preserve checkbox */
	SendMessage(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_ZOOM_ASPECTPRESERVE), BM_SETCHECK, (G_cps.bZoomAspectPreserve?BST_CHECKED:BST_UNCHECKED), 0);

	/* Expand plasma to fill screen checkbox */
	SendMessage(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_EXPANDPLASMATOFILLSCREEN), BM_SETCHECK, (G_cps.bExpandPlasmaToFillScreen?BST_CHECKED:BST_UNCHECKED), 0);

	/* Confine everything to square checkbox */
	SendMessage(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_CONFINEEVERYTHINGTOSQUARE), BM_SETCHECK, (G_cps.bConfineEverythingToSquare?BST_CHECKED:BST_UNCHECKED), 0);



	/* Init Plasma settings */


	/* Global Plasma Speed */
	sprintf(szTmpNumString, "%f", G_cps.nPlasmaGlobalSpeed);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_GLOBAL_SPEED_EDIT), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTmpNumString));
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_GLOBAL_SPEED_EDIT), EM_LIMITTEXT, MAX_NUMERIC_EDIT_LENGTH, 0);

	/* Global Plasma Seed Magnification */
	sprintf(szTmpNumString, "%f", G_cps.nPlasmaGlobalSeedMultiplier);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_GLOBAL_SEEDMULTIPLIER_EDIT), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTmpNumString));
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_GLOBAL_SEEDMULTIPLIER_EDIT), EM_LIMITTEXT, MAX_NUMERIC_EDIT_LENGTH, 0);

	/* Full intensity wrap */
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_CHECK_FULLINTENSITYWRAP), BM_SETCHECK, (G_cps.bFullIntensityHueWrap?BST_CHECKED:BST_UNCHECKED), 0);

	/* Plasma intensity */
	sprintf(szTmpNumString, "%d", G_cps.cIntensity);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_INTENSITY_EDIT), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTmpNumString));
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_INTENSITY_EDIT), EM_LIMITTEXT, MAX_NUMERIC_EDIT_LENGTH, 0);

	/* Plasma intensity rise time */
	sprintf(szTmpNumString, "%f", G_cps.nIntensityRiseTime);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_INTENSITY_RISE_TIME_EDIT), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTmpNumString));
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_INTENSITY_RISE_TIME_EDIT), EM_LIMITTEXT, MAX_NUMERIC_EDIT_LENGTH, 0);

	/* Confine lissajousses to square checkbox */
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_CHECK_CONFINELISSAJOUSSESTOSQUARE), BM_SETCHECK, (G_cps.bConfineLissajoussesToSquare?BST_CHECKED:BST_UNCHECKED), 0);



	/* Init Plasma colour settings (when no image) */

	/* Global Plasma colour Speed */
	sprintf(szTmpNumString, "%f", G_cps.nPlasmaColourGlobalSpeed);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_GLOBAL_SPEED_EDIT), WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szTmpNumString));
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_GLOBAL_SPEED_EDIT), EM_LIMITTEXT, MAX_NUMERIC_EDIT_LENGTH, 0);

	/* Funky palette effect checkbox */
	switch(G_cps.psPaletteSource)
	{
		case cpPALETTESOURCE_NONE:
		{
			CheckRadioButton(hwndDlg, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_SIMPLEPALETTE, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_CUSTOMPALETTE, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_SIMPLEPALETTE);
		}
		break;
		
		case cpPALETTESOURCE_FUNKYPALETTEEFFECT:
		{
			CheckRadioButton(hwndDlg, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_SIMPLEPALETTE, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_CUSTOMPALETTE, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_FUNKYPALETTE);
		}
		break;

		case cpPALETTESOURCE_EXTERNALPALETTE:
		{
			CheckRadioButton(hwndDlg, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_SIMPLEPALETTE, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_CUSTOMPALETTE, IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_CUSTOMPALETTE);
		}
		break;

		default:
		{
			TRACE("Invalid palette-xsource (how could this be, we checked when parsing the input)");
//					set to CPDEFAULT_PALETTESOURCE
		}
		break;
	}





	/* Which colour-space to use for the funky palette effect */
	switch(G_cps.csFunkyPaletteEffectColourSpace)
	{
		case cpCOLOURSPACE_RGB:
		{
			CheckRadioButton(hwndDlg, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_RGB, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HLS, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_RGB);
		}
		break;

		case cpCOLOURSPACE_HSV:
		{
			CheckRadioButton(hwndDlg, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_RGB, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HLS, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HSV);
		}
		break;

		case cpCOLOURSPACE_HLS:
		{
			CheckRadioButton(hwndDlg, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_RGB, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HLS, IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HLS);
		}
		break;

		default:
		{
			TRACE("Invalid colour-space (how could this be, we checked when parsing the input)");
//					set to CPDEFAULT_FUNKYPALETTECOLOURSPACE
		}
		break;
	}


	/* External palette filename */

	// WARNING: WM_SETTEXT may require the string to be in a differnt format than  G_cps.szFileName .
	SendMessage(hPlasmacoloursCustompaletteFileNameEdit, WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) G_cps.szPaletteSourceFileName));
	// TODO: If filename surrounded by ""'s, remove them.






	/* Init Plasma effects settings (when using an image) */


	/* Which colour-space to use for the plasma effects on the image */
	switch(G_cps.csColourSpaceToUse)
	{
		case cpCOLOURSPACE_RGB:
		{
			CheckRadioButton(hwndDlg, IDC_PLASFX_RADIO_RGB, IDC_PLASFX_RADIO_HLS, IDC_PLASFX_RADIO_RGB);
		}
		break;

		case cpCOLOURSPACE_HSV:
		{
			CheckRadioButton(hwndDlg, IDC_PLASFX_RADIO_RGB, IDC_PLASFX_RADIO_HLS, IDC_PLASFX_RADIO_HSV);
		}
		break;

		case cpCOLOURSPACE_HLS:
		{
			CheckRadioButton(hwndDlg, IDC_PLASFX_RADIO_RGB, IDC_PLASFX_RADIO_HLS, IDC_PLASFX_RADIO_HLS);
		}
		break;

		default:
		{
			TRACE("Invalid colour-space (how could this be, we checked when parsing the input)");
//					set to CPDEFAULT_PLASFX_USECOLOURSPACE
		}
		break;
	}


	/* Colour-space checkboxes */
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_R), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_RGB][0]?BST_CHECKED:BST_UNCHECKED), 0);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_G), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_RGB][1]?BST_CHECKED:BST_UNCHECKED), 0);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_B), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_RGB][2]?BST_CHECKED:BST_UNCHECKED), 0);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_H), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HSV][0]?BST_CHECKED:BST_UNCHECKED), 0);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_S), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HSV][1]?BST_CHECKED:BST_UNCHECKED), 0);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_V), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HSV][2]?BST_CHECKED:BST_UNCHECKED), 0);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_H), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HLS][0]?BST_CHECKED:BST_UNCHECKED), 0);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_L), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HLS][1]?BST_CHECKED:BST_UNCHECKED), 0);
	SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_S), BM_SETCHECK, (G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HLS][2]?BST_CHECKED:BST_UNCHECKED), 0);


}



/* dialog procedure for the settings dialog */
BOOL CALLBACK
cpSettingsDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LRESULT lr;

	char szTmpNumString[MAX_NUMERIC_EDIT_LENGTH+1];

	/* Grab a handle to commonly-used controls */
	HWND hImgTypeFileNameEdit = GetDlgItem(hwndDlg, IDC_IMAGETYPE_FILENAMEEDIT);
	HWND hPlasmacoloursCustompaletteFileNameEdit = GetDlgItem(hwndDlg, IDC_PLASMACOLOURS_CUSTOMPALETTE_PALETTEFILENAMEEDIT);


	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			cpInitCPS(&g_cpsOldSettings);

			/* We are making a copy of params so we can do stuff with a temp copy of the params while in the dialog. This is so we can restore them if we cancel. */
			cpCopyCPS(&g_cpsOldSettings,&G_cps);


			cpSettingsDlgSetToCurrentSettings(hwndDlg);

			return TRUE;
		}



		case WM_DESTROY:
		{
			cpDestroyCPS(&g_cpsOldSettings);
			return TRUE;
		}



		case WM_DROPFILES:
		{
			// For now, only do files dropped on the entire dialog. Should really do for just a file-editbox.

			// Would using the following function help?
			// BOOL DragQueryPoint(HDROP hDrop,LPPOINT lppt);
			// It would only find the location of the mousecursor and not solve the underlying problem.


			HDROP hdDrop = (HDROP)wParam;


			int nNumFiles = DragQueryFile ( hdDrop, -1, NULL, 0 );

			if(nNumFiles)
			{
				/* Only retrieve the first file if multiple files were dropped. */
				char szName[MAX_PATH];

				// TODO: Instead of using a stirng of length MAX_PATH, use malloc()
				// int nRequiredStringLength = DragQueryFile ( hdDrop, 0, NULL, MAX_PATH )
				// char *szName = (char *) malloc(nRequiredStringLength)*sizeof(char);


				if(DragQueryFile ( hdDrop, 0, szName, MAX_PATH ) > 0)
				{
					if(G_cps.isImgSource == cpIMGTYPE_FILE)
					{
						SendMessage(hImgTypeFileNameEdit ,WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szName));
					}
					else if(G_cps.isImgSource == cpIMGTYPE_NONE && G_cps.psPaletteSource==cpPALETTESOURCE_EXTERNALPALETTE)
					{
						SendMessage(hPlasmacoloursCustompaletteFileNameEdit ,WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szName));
					}
					else
					{
						return FALSE;
					}

					// ?: Should we update the var here, or in the edit-box's message?
				}


			}


			return TRUE;
		}



		case WM_COMMAND:
		{

			switch (LOWORD(wParam))
			{
				/* * Global settings * */

				case IDC_GLOBAL_SPEED_EDIT:
				{
					switch (HIWORD(wParam))
					{
						case EN_UPDATE:
						{
							// TODO: Instead of doing this each update, we could do it when the editbox loses focus?
							SendMessage(GetDlgItem(hwndDlg, IDC_GLOBAL_SPEED_EDIT), WM_GETTEXT, (WPARAM)(MAX_NUMERIC_EDIT_LENGTH+1), (LPARAM) ((LPCTSTR) szTmpNumString));
							G_cps.nGlobalSpeed = atof(szTmpNumString);
							// TODO: Test szTmpString to see if it's a number
							return TRUE;
						}
					}

					return FALSE;
				}



				/* * Image settings * */

				/* The file-edit and browse button etc. are greyed out appropriately */

				case IDC_IMAGETYPE_RADIO_NOIMAGE:
				{
					G_cps.isImgSource = cpIMGTYPE_NONE;

					_cpGreyOutUnusedImageSourceControls(hwndDlg);
					_cpGreyOutUnusedPlasmaControls(hwndDlg);
					_cpGreyOutUnusedZoomingControls(hwndDlg);
					_cpGreyOutUnusedPlasFXCSControls(hwndDlg);

					return TRUE;
				}

				case IDC_IMAGETYPE_RADIO_BUILTIN:
				{
					G_cps.isImgSource = cpIMGTYPE_BUILTIN;

					_cpGreyOutUnusedImageSourceControls(hwndDlg);
					_cpGreyOutUnusedPlasmaControls(hwndDlg);
					_cpGreyOutUnusedZoomingControls(hwndDlg);
					_cpGreyOutUnusedPlasFXCSControls(hwndDlg);

					return TRUE;
				}

				case IDC_IMAGETYPE_RADIO_DESKTOP:
				{
					G_cps.isImgSource = cpIMGTYPE_DESKTOP;

					_cpGreyOutUnusedImageSourceControls(hwndDlg);
					_cpGreyOutUnusedPlasmaControls(hwndDlg);
					_cpGreyOutUnusedZoomingControls(hwndDlg);
					_cpGreyOutUnusedPlasFXCSControls(hwndDlg);

					return TRUE;
				}

				case IDC_IMAGETYPE_RADIO_DESKTOPWALLPAPER:
				{
					G_cps.isImgSource = cpIMGTYPE_DESKTOP_WALLPAPER;

					_cpGreyOutUnusedImageSourceControls(hwndDlg);
					_cpGreyOutUnusedPlasmaControls(hwndDlg);
					_cpGreyOutUnusedZoomingControls(hwndDlg);
					_cpGreyOutUnusedPlasFXCSControls(hwndDlg);

					return TRUE;
				}

				case IDC_IMAGETYPE_RADIO_FILE:
				{
					G_cps.isImgSource = cpIMGTYPE_FILE;

					_cpGreyOutUnusedImageSourceControls(hwndDlg);
					_cpGreyOutUnusedPlasmaControls(hwndDlg);
					_cpGreyOutUnusedZoomingControls(hwndDlg);
					_cpGreyOutUnusedPlasFXCSControls(hwndDlg);

					return TRUE;
				}




				/* Image filename */

				case IDC_IMAGETYPE_FILENAMEEDIT:
				{
					switch (HIWORD(wParam))
					{
						case EN_UPDATE:
						{
							// TODO: Instead of doing this each update, we could do it when the editbox loses focus?
							// That way, we can also validate the file (just give a friendly warning - don't force them to enter a valid one)
							// ?: Does pressing OK make sure the lose-focus message is processed before the OK message?
							// ?: If using drag-and-drop, would the edit-box get focus in the first place?

							lr = SendMessage(hImgTypeFileNameEdit, WM_GETTEXTLENGTH, 0, 0);
#if 0	// Used when G_cps.szFileName was malloc()'d rather than a buffer.
							{


								char *szTmp;	/* Used in case realloc fails */

								szTmp = realloc(G_cps.szFileName, ((int)lr+1)*sizeof(TCHAR));
								if(!szTmp)
								{
									/* Could not alloc mem for filename - for now, just update the textbox with the old */
									// WARNING: WM_SETTEXT may require the string to be in a differnt format than  G_cps.szFileName .
									SendMessage(hImgTypeFileNameEdit, WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) G_cps.szFileName));
									return TRUE;
								}
								else
								{
									/* Successful realloc() */
									G_cps.szFileName = szTmp;
								}

							}
#endif
							// WARNING: WM_GETTEXT may return a string in a differnt format than  G_cps.szFileName .
							SendMessage(hImgTypeFileNameEdit, WM_GETTEXT, (WPARAM)(CPPATHSTRINGSIZE/sizeof(TCHAR)), (LPARAM) ((LPCTSTR) G_cps.szFileName));
							// TODO: if((lr+1)*sizeof(TCHAR)>CPPATHSTRINGSIZE), warn (currently just truncated) and do SendMessage(hImgTypeFileNameEdit, WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) G_cps.szFileName)); to reflect truncatedness.


							return TRUE;
						}


						/*
						case WM_DROPFILES:
						{
							int a=1;

							return TRUE;
						}
						*/


						// File that is dragged onto it exists, right??? Knowing microsoft, I'm sure an idiot can break it. Maybe Microsoft needs idiots to test it's GUI.
					}

					return FALSE;
				}


				case IDC_IMAGETYPE_FILENAMEBROWSEBUTTON:
				{
					char szFileName[CPPATHSTRINGSIZE];


					/* Set the file-select to display the previously-selected file */
					SendMessage(hImgTypeFileNameEdit, WM_GETTEXT, (WPARAM)(CPPATHSTRINGSIZE/sizeof(TCHAR)), (LPARAM) ((LPCTSTR) szFileName));

					if(cpGetImageFilenameFromWinFileSelect(szFileName, hwndDlg))
					{
						/* We chose something */
						SendMessage(hImgTypeFileNameEdit, WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szFileName));
					}


					return TRUE;
				}



				/* * Rendering settings * */

				/* Image resolution source */
				case IDC_RENDERING_RADIO_IMAGE:
				{
					G_cps.irsImgResSource = cpIMGRESSOURCE_IMAGE;
					_cpGreyOutUnusedResolutionControls(hwndDlg);

					return TRUE;
				}
				break;

				case IDC_RENDERING_RADIO_CUSTOM:
				{
					G_cps.irsImgResSource = cpIMGRESSOURCE_CUSTOM;
					_cpGreyOutUnusedResolutionControls(hwndDlg);

					return TRUE;
				}
				break;




				/* Screen custom-resolution */
				case IDC_RENDERING_COMBO_XY:
				{
					// ?: Apart from setting W and H, do we need to do anything else (eg. change BPP?)
					// No, coz it's the BPP that sets the rez. But we could do vice versa too.
					// If we don't need to do owt else, then we might want to read this when the OK button is pressed.

					switch (HIWORD(wParam))
					{
						case CBN_SELCHANGE:
						{
							long nModeID;
							GFX_MODE *mpMode;

							HWND hCtrl;

							// We don't need to bother changing the BPP combo with _cpFillScreenRezBPPCombo(). The bpp combo just shows all available bpps and not necesarily those for this mode. If we do pick a bpp not supported by this resolution, the resolution will change.

							
							/* Set the mode to the newly selected mode */
							hCtrl = GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_XY);
							nModeID = SendMessage(hCtrl, CB_GETITEMDATA, SendMessage(hCtrl, CB_GETCURSEL, 0, 0), 0);
							mpMode = &g_gmlpModes->mode[nModeID];

							G_cps.nWidth = mpMode->width;
							G_cps.nHeight = mpMode->height;
							// BPP not affected here (but it might be if we always have all available sizes in the modeslist

							// TODO: Sanity-Checks to make sure the modes and listitems exist.

						}
						break;
					}
				}
				break;


				case IDC_RENDERING_COMBO_COLOURDEPTH:
				{

					switch (HIWORD(wParam))
					{
						case CBN_SELCHANGE:
						{
							HWND hCtrl;

							long nBPP;
							int nModeID;
							GFX_MODE *mpMode;


							hCtrl = GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_COLOURDEPTH);
							nBPP = SendMessage(hCtrl, CB_GETITEMDATA, SendMessage(hCtrl, CB_GETCURSEL, 0, 0), 0);

							/* Reset the rez-size combo. Not only does it update the list of available rez's at that BPP, but it also updates the list's mode-ID's */
							if(_cpFillScreenRezSizeCombo(hwndDlg, nBPP) == 0)
							{
								ASSERT(FALSE);	/* If a BPP value is on the Combo, then there's at least one mode of that BPP */
							}


							/* Now let's set the newly-updated size-combo to the same size as it was before (if we can) */

							hCtrl = GetDlgItem(hwndDlg, IDC_RENDERING_COMBO_XY);
							nModeID = _cpGetModeIDFromModeSizeInComboBox(hCtrl, G_cps.nWidth,G_cps.nHeight);
							if(nModeID == -1)
							{
								/* Oh dear, we can't set this size for this BPP. We have to find another size. */
								cpFindRezWithLargestAreaForGivenBPP(&G_cps.nWidth, &G_cps.nHeight, nBPP, g_gmlpModes);
								nModeID = _cpGetModeIDFromModeSizeInComboBox(hCtrl, G_cps.nWidth,G_cps.nHeight);
								ASSERT(nModeID != -1);	/* We already know we can use the colour-depth (it's in the BPP-list) so therefore, there must be an available mode in that colourdepth */
							}


							/* Now we have a ModeID, lets set the mode in the combobox */
							if(!_cpSetScreenRezComboSize(hCtrl, nModeID))
							{
								ASSERT(FALSE);	/* By now, if nModeID!=-1, this should never happen */
							}


							mpMode = &g_gmlpModes->mode[nModeID];


							/* Set bpp to our newly chosen value */
							G_cps.nBPP = nBPP;
							/* And if this involved changing the height and width, cpFindRezWithLargestAreaForGivenBPP() would have changed this already. */

						}
					}

				}





				/* Zoom checkbox */
				case IDC_RENDERING_CHECK_ZOOM:
				{
					G_cps.bZoom = (SendMessage(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_ZOOM), BM_GETCHECK, 0, 0)==BST_CHECKED);
					_cpGreyOutUnusedZoomingControlsZoomOptions(hwndDlg);
					return TRUE;
				}

				/* Zoom aspect preserve checkbox */
				case IDC_RENDERING_CHECK_ZOOM_ASPECTPRESERVE:
				{
					G_cps.bZoomAspectPreserve = (SendMessage(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_ZOOM_ASPECTPRESERVE), BM_GETCHECK, 0, 0)==BST_CHECKED);
					_cpGreyOutUnusedExpandPlasmaToFillScreenControls(hwndDlg);
					return TRUE;
				}

				/* Expand plasma to fill screen checkbox */
				case IDC_RENDERING_CHECK_EXPANDPLASMATOFILLSCREEN:
				{
					G_cps.bExpandPlasmaToFillScreen = (SendMessage(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_EXPANDPLASMATOFILLSCREEN), BM_GETCHECK, 0, 0)==BST_CHECKED);
					_cpGreyOutUnusedExpandPlasmaToFillScreenControls(hwndDlg);
					return TRUE;
				}

				/* Confine everything to square checkbox */
				case IDC_RENDERING_CHECK_CONFINEEVERYTHINGTOSQUARE:
				{
					G_cps.bConfineEverythingToSquare = (SendMessage(GetDlgItem(hwndDlg, IDC_RENDERING_CHECK_CONFINEEVERYTHINGTOSQUARE), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}



				/* * Plasma settings * */

				case IDC_PLASMA_GLOBAL_SPEED_EDIT:
				{
					switch (HIWORD(wParam))
					{
						case EN_UPDATE:
						{
							// TODO: Instead of doing this each update, we could do it when the editbox loses focus?
							SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_GLOBAL_SPEED_EDIT), WM_GETTEXT, (WPARAM)(MAX_NUMERIC_EDIT_LENGTH+1), (LPARAM) ((LPCTSTR) szTmpNumString));
							G_cps.nPlasmaGlobalSpeed = atof(szTmpNumString);
							// TODO: Test szTmpString to see if it's a number
							return TRUE;
						}
					}

					return FALSE;
				}


				case IDC_PLASMA_GLOBAL_SEEDMULTIPLIER_EDIT:
				{
					switch (HIWORD(wParam))
					{
						case EN_UPDATE:
						{
							// TODO: Instead of doing this each update, we could do it when the editbox loses focus?
							SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_GLOBAL_SEEDMULTIPLIER_EDIT), WM_GETTEXT, (WPARAM)(MAX_NUMERIC_EDIT_LENGTH+1), (LPARAM) ((LPCTSTR) szTmpNumString));
							G_cps.nPlasmaGlobalSeedMultiplier = atof(szTmpNumString);
							// TODO: Test szTmpString to see if it's a number
							return TRUE;
						}
					}

					return FALSE;
				}

				case IDC_PLASMA_CHECK_FULLINTENSITYWRAP:
				{
					G_cps.bFullIntensityHueWrap = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_CHECK_FULLINTENSITYWRAP), BM_GETCHECK, 0, 0)==BST_CHECKED);
					_cpGreyOutUnusedPlasmaIntensityControls(hwndDlg);
					return TRUE;
				}

				case IDC_PLASMA_INTENSITY_EDIT:
				{
					switch (HIWORD(wParam))
					{
						case EN_UPDATE:
						{
							// TODO: Instead of doing this each update, we could do it when the editbox loses focus?
							SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_INTENSITY_EDIT), WM_GETTEXT, (WPARAM)(MAX_NUMERIC_EDIT_LENGTH+1), (LPARAM) ((LPCTSTR) szTmpNumString));
							G_cps.cIntensity = atol(szTmpNumString);
							// TODO: Test szTmpString to see if it's a number
							return TRUE;
						}
					}

					return FALSE;
				}

				case IDC_PLASMA_INTENSITY_RISE_TIME_EDIT:
				{
					switch (HIWORD(wParam))
					{
						case EN_UPDATE:
						{
							// TODO: Instead of doing this each update, we could do it when the editbox loses focus?
							SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_INTENSITY_RISE_TIME_EDIT), WM_GETTEXT, (WPARAM)(MAX_NUMERIC_EDIT_LENGTH+1), (LPARAM) ((LPCTSTR) szTmpNumString));
							G_cps.nIntensityRiseTime = atof(szTmpNumString);
							// TODO: Test szTmpString to see if it's a number
							// TODO: Do not allow negative numbers.
							return TRUE;
						}
					}

					return FALSE;
				}


				/* Confine lissajousses to square checkbox */
				case IDC_PLASMA_CHECK_CONFINELISSAJOUSSESTOSQUARE:
				{
					G_cps.bConfineLissajoussesToSquare = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASMA_CHECK_CONFINELISSAJOUSSESTOSQUARE), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}




				/* * Plasma colour settings (when no image) * */

				case IDC_PLASMACOLOUR_GLOBAL_SPEED_EDIT:
				{
					switch (HIWORD(wParam))
					{
						case EN_UPDATE:
						{
							// TODO: Instead of doing this each update, we could do it when the editbox loses focus?
							SendMessage(GetDlgItem(hwndDlg, IDC_PLASMACOLOUR_GLOBAL_SPEED_EDIT), WM_GETTEXT, (WPARAM)(MAX_NUMERIC_EDIT_LENGTH+1), (LPARAM) ((LPCTSTR) szTmpNumString));
							G_cps.nPlasmaColourGlobalSpeed = atof(szTmpNumString);
							// TODO: Test szTmpString to see if it's a number
							return TRUE;
						}
					}

					return FALSE;
				}



				/* Palette source radios */
				case IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_SIMPLEPALETTE:
				{
					G_cps.psPaletteSource=cpPALETTESOURCE_NONE;
					_cpGreyOutUnusedPaletteSourceControls(hwndDlg);
					_cpGreyOutUnusedPlasmaControls(hwndDlg);
					return TRUE;
				}

				case IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_FUNKYPALETTE:
				{
					G_cps.psPaletteSource=cpPALETTESOURCE_FUNKYPALETTEEFFECT;
					_cpGreyOutUnusedPaletteSourceControls(hwndDlg);
					_cpGreyOutUnusedPlasmaControls(hwndDlg);
					return TRUE;
				}

				case IDC_PLASMACOLOUR_PALETTESOURCE_RADIO_CUSTOMPALETTE:
				{
					G_cps.psPaletteSource=cpPALETTESOURCE_EXTERNALPALETTE;
					_cpGreyOutUnusedPaletteSourceControls(hwndDlg);
					_cpGreyOutUnusedPlasmaControls(hwndDlg);
					return TRUE;
				}




				/* Funky palette colourspace radios */
				case IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_RGB:
				{
					G_cps.csFunkyPaletteEffectColourSpace = cpCOLOURSPACE_RGB;
					return TRUE;
				}

				case IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HSV:
				{
					G_cps.csFunkyPaletteEffectColourSpace = cpCOLOURSPACE_HSV;
					return TRUE;
				}

				case IDC_PLASMACOLOUR_FUNKYPALETTECOLOURSPACE_RADIO_HLS:
				{
					G_cps.csFunkyPaletteEffectColourSpace = cpCOLOURSPACE_HLS;
					return TRUE;
				}






				/* Palette filename */

				case IDC_PLASMACOLOURS_CUSTOMPALETTE_PALETTEFILENAMEEDIT:
				{
					switch (HIWORD(wParam))
					{
						case EN_UPDATE:
						{
							// TODO: Instead of doing this each update, we could do it when the editbox loses focus?
							// That way, we can also validate the file (just give a friendly warning - don't force them to enter a valid one)
							// ?: Does pressing OK make sure the lose-focus message is processed before the OK message?
							// ?: If using drag-and-drop, would the edit-box get focus in the first place?

							lr = SendMessage(hPlasmacoloursCustompaletteFileNameEdit, WM_GETTEXTLENGTH, 0, 0);
							// WARNING: WM_GETTEXT may return a string in a differnt format than  G_cps.szFileName .
							SendMessage(hPlasmacoloursCustompaletteFileNameEdit, WM_GETTEXT, (WPARAM)(CPPATHSTRINGSIZE/sizeof(TCHAR)), (LPARAM) ((LPCTSTR) G_cps.szPaletteSourceFileName));
							// TODO: if((lr+1)*sizeof(TCHAR)>CPPATHSTRINGSIZE), warn (currently just truncated) and do SendMessage(hPlasmacoloursCustompaletteFileNameEdit, WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) G_cps.szPaletteSourceFileName)); to reflect truncatedness.


							return TRUE;
						}
					}

					return FALSE;
				}


				case IDC_PLASMACOLOURS_CUSTOMPALETTE_PALETTEFILENAMEBROWSEBUTTON:
				{
					char szFileName[CPPATHSTRINGSIZE];


					/* Set the file-select to display the previously-selected file */
					SendMessage(hPlasmacoloursCustompaletteFileNameEdit, WM_GETTEXT, (WPARAM)(CPPATHSTRINGSIZE/sizeof(TCHAR)), (LPARAM) ((LPCTSTR) szFileName));

					if(cpGetImageFilenameFromWinFileSelect(szFileName, hwndDlg))
					{
						/* We chose something */
						SendMessage(hPlasmacoloursCustompaletteFileNameEdit, WM_SETTEXT, 0, (LPARAM) ((LPCTSTR) szFileName));
					}


					return TRUE;
				}








				/* * Plasma effects settings (when using an image) * */


				/* Which colour-space to use */
				case IDC_PLASFX_RADIO_RGB:
				{
					G_cps.csColourSpaceToUse = cpCOLOURSPACE_RGB;
					_cpGreyOutUnusedPlasFXCSControls(hwndDlg);

					return TRUE;
				}

				case IDC_PLASFX_RADIO_HSV:
				{
					G_cps.csColourSpaceToUse = cpCOLOURSPACE_HSV;
					_cpGreyOutUnusedPlasFXCSControls(hwndDlg);

					return TRUE;
				}

				case IDC_PLASFX_RADIO_HLS:
				{
					G_cps.csColourSpaceToUse = cpCOLOURSPACE_HLS;
					_cpGreyOutUnusedPlasFXCSControls(hwndDlg);

					return TRUE;
				}


				/* Colour-space checkboxes */
				case IDC_PLASFX_CHECK_RGB_R:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_RGB][0] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_R), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}

				case IDC_PLASFX_CHECK_RGB_G:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_RGB][1] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_G), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}

				case IDC_PLASFX_CHECK_RGB_B:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_RGB][2] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_RGB_B), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}

				case IDC_PLASFX_CHECK_HSV_H:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HSV][0] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_H), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}

				case IDC_PLASFX_CHECK_HSV_S:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HSV][1] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_S), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}

				case IDC_PLASFX_CHECK_HSV_V:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HSV][2] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HSV_V), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}

				case IDC_PLASFX_CHECK_HLS_H:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HLS][0] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_H), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}

				case IDC_PLASFX_CHECK_HLS_L:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HLS][1] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_L), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}

				case IDC_PLASFX_CHECK_HLS_S:
				{
					G_cps.baaColourSpaceFlags[CPCOLOURSPACEINDEX_HLS][2] = (SendMessage(GetDlgItem(hwndDlg, IDC_PLASFX_CHECK_HLS_S), BM_GETCHECK, 0, 0)==BST_CHECKED);
					return TRUE;
				}



				case IDABOUT:
				{
					DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_CPABOUT), hwndDlg, cpAboutDlgProc);
					return TRUE;
				}

				case IDRESTOREDEFAULTS:
				{
					// ?: If using multi-paged settings dialog, should it just restore the settings for the tab or all tabs?

					int nMsgBoxVal = MessageBox(hwndDlg, "Restoring the default settings will overwrite the current settings. Continue?", "Just a little warning", MB_YESNO|MB_ICONWARNING);

					if(nMsgBoxVal==IDYES)
					{
						cpCopyCPS(&G_cps,&G_cpsDefaults);
						cpSettingsDlgSetToCurrentSettings(hwndDlg);
					}

					return TRUE;
				}

				case IDTEST:
				{
					/* Do a test of the current settings */
					_cpDoTest(hwndDlg);
					return TRUE;
				}


				case IDOK:
				{

					// TODO: Check that params are valid/sane (or could that be done on a per-control basis?)
					// A: Methinx it's best to do the validation on a per-control basis.


					// ?: Should this be done in cpCheckSanityOfConfigurationSettingsAndIfInsaneSetToDefaults() ?
					if(G_cps.isImgSource == cpIMGTYPE_FILE && !exists(G_cps.szFileName))
					{
						MessageBox(hwndDlg, "The file does not exist\nEither change the file-name or change the image-source.", "Just a friendly little warning", MB_ICONERROR);
					}


					/* Briefly install Allegro so we can save the config and build a gfx mode list. */
					// NOTE: SS may be running in preview mode. Make sure the settings are updated.
					// Actually, when this settings dialog is called, it stops preview-mode, and restarts it on dialog-exit.
					// NOTE: If we've already init'd Allegro, make sure this init'ing isn't called.
					if(!cpSetupChromaPlasProgramInitAllegro(FALSE, FALSE, FALSE))	/* We just need to write to the config file - hence bUseSystemDriver==FALSE */
					{
						exit(0);
					}
					cpSaveConfig();
					cpCleanupChromaPlasProgramTiniAllegro();
					EndDialog(hwndDlg,1);


					return TRUE;
				}

				case IDCANCEL:
				{
					/* Restore old settings if canceled */
					// At the moment this isn't needed, but we might end up calling this from within the app.
					cpCopyCPS(&G_cps,&g_cpsOldSettings);


					EndDialog(hwndDlg, 0);
					return TRUE;
				}


//				case IDC_PLASMA_INTENSITY_SLIDER:
//				{
//					return FALSE;
//				}


			}
		} break;



		case WM_CLOSE:
		{
			/* Make sure closing this window has the same effect as pressing 'Cancel' */
			PostMessage(hwndDlg,WM_COMMAND,IDCANCEL,0);
			return TRUE;
		}




	}

   return FALSE;
}





/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                          Windows Screensaver functions.

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */



/* The settings dialog function */
// ?: In Windows, should this be made available outside the screensaver too?
int
cpDoSettings_Win_SS(HWND hParentWnd)
{
	// ?: Is there somehow a means of getting/building the list of available resolutions with SYSTEM_NONE?
	// Then we can do cpSetupChromaPlasProgramInitAllegro(FALSE)

	/* Briefly install Allegro so we can load the config and build a gfx mode list (hence using system driver). */
	// Done here and not in WM_INITDIALOG:
	TRACE("Briefly starting Allegro.\n");
	if(!cpSetupChromaPlasProgramInitAllegro(TRUE, TRUE, TRUE))
	{
		return -1;
	}


	if(!(g_gmlpModes = get_gfx_mode_list(CPGFXCARD) ))
	{

#ifdef _DEBUG
		{
			char szGFXCardIDString[5];	/* Gfx-mode ID-string used by chGetCurrentModeIDString() */
			TRACE("EEK! Could not get the GFX_MODE_LIST for card '%s'...\n", aeGetAllegroIDStringFromAllegroID(szGFXCardIDString,CPGFXCARD));
		}
#endif

		cpCleanupChromaPlasProgramTiniAllegro();
		return -1;
	}

	cpTRACEGFXmodelistContents(g_gmlpModes, CPGFXCARD);


	cpCleanupChromaPlasProgramTiniAllegro();	// Now we have the modeslist, we can safely shutdown Allegro
	TRACE("Shutting down Allegro after briefly starting it.\n");

	/* And now, bring up the dialog box */
   	/* int rval = */ DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_CPSETTINGS), hParentWnd, cpSettingsDlgProc);
	/* DWORD dwError = GetLastError(); */


	destroy_gfx_mode_list(g_gmlpModes);
	g_gmlpModes = NULL;

	return 0;
}



/* the password dialog function */
// Copied from Allegro 4.2.3.1 screensaver example.
int
cpDoPassword_Win_SS(HWND hParentWnd)
{
	// ?: Is this only nesc. on Windows 95/98/ME or is it nesc for all Windowses?

    /* Load the password change DLL */
    HINSTANCE mpr = LoadLibrary(TEXT("MPR.DLL"));
    if (mpr)
    {
        /* Grab the password change function from it */
        typedef DWORD (PASCAL *PWCHGPROC)(LPCSTR, HWND, DWORD, LPVOID);
        PWCHGPROC pwd = (PWCHGPROC)GetProcAddress(mpr, "PwdChangePasswordA");

        /* Do the password change */
        if ( pwd != NULL )
            pwd("SCRSAVE", hParentWnd, 0, NULL);

        /* Free the library */
        FreeLibrary(mpr);
        mpr=NULL;
    }

   return 0;
}



/* the screensaver preview function window-callback */
LRESULT CALLBACK cpPreviewWndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
		case WM_CREATE:
		{
			SetTimer(hwnd, 1, CPPREVIEWNUMMSECPERTICK, NULL);

			// In 8-bit mode, in order to have the palette constantly update, we would put this in WM_PAINT
			// However, that leads to a massive slowdown and desktop-flicker, so we do this here instead.
			// TODO: Some scheme for guessing the best palette - image source colours + the resulting colours of applying the stimulus.
			// ?: Is it just best do do the preview on a 32-bit image (a memory-bitmap (or system-birmap(?))) instead?
			// In 8-bit, we could usually just set_palette_to_hdc() the 332-palette (or some other palette that leaves spaces free for the 16(or20) windows colours).
			hdc = BeginPaint(hwnd, &ps);
			set_palette_to_hdc(hdc, _current_palette);	// WARNING: when the GDI system color palette is explicitly changed, (by another application, for example) the current Allegro palette is not updated along with it!
			EndPaint(hwnd, &ps);
			return 0;
		}

		case WM_TIMER:
		{
			float nTimeDelta = (1000.0f/((float)CPPREVIEWNUMMSECPERTICK))/(float)CPREFERENCEREFRESHRATE;
			cpDoLogic(nTimeDelta);
			InvalidateRect(hwnd, NULL, FALSE);
			return 0;
		}

		case WM_PAINT:
		{
			hdc = BeginPaint(hwnd, &ps);
			cpDoRender(TRUE);
			draw_to_hdc(hdc, G_bmpDest, 0, 0);
			// ?: Use stretch_blit_to_hdc()?
			EndPaint(hwnd, &ps);
			return 0;
		}

		case WM_DESTROY:
		{
			KillTimer(hwnd, 1);
			PostQuitMessage(0);
			return 0;
		}
	}

	return DefWindowProc(hwnd, message, wParam, lParam);
}


/* the screensaver preview function */
int
cpDoPreview_Win_SS(HWND hParentWnd)
{

	WNDCLASS wndclass;
	HWND hwnd;
	MSG msg;
	RECT rc;

	int nDestWidth, nDestHeight, nDestBPP;



	if(!g_hPrevInstance)
	{
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = cpPreviewWndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = g_hInstance;
		wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
		wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground = NULL;
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = "sspreview";

		RegisterClass(&wndclass);
	}

	if(hParentWnd)
	{
		GetClientRect(hParentWnd, &rc);
	}
	else
	{
		rc.right = rc.bottom = 256;
	}

	/* Setup a minimalistid Allegro. */
	if(!cpSetupChromaPlasProgramInitAllegro(FALSE, TRUE, TRUE))	// No system driver for Allegro
	{
		exit(0);
	}

	set_palette(default_palette);
	set_gdi_color_format();	/* Make sure we get the RGB<->BGR thing sorted out */


	nDestWidth = rc.right;
	nDestHeight = rc.bottom;
	nDestBPP = 32;	// TODO: Other colour depths. ?: Will 32 always be sufficient for the preview-window (A: YES).


	cpResetGlobalExitFlag();
	cpResetAppInForegroundFlag();


	if(!cpInitChromaPlas(FALSE, nDestWidth, nDestHeight, nDestBPP))
	{
		cpCleanupChromaPlasProgramTiniAllegro();
		exit(0);
	}


	hwnd = CreateWindow("sspreview", NULL, WS_CHILD, 0, 0, rc.right, rc.bottom, hParentWnd, NULL, g_hInstance, NULL);

	ShowWindow(hwnd, SW_SHOW);
	UpdateWindow(hwnd);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}


	cpTiniChromaPlas(FALSE);

	cpCleanupChromaPlasProgramTiniAllegro();

	return msg.wParam;
}
