/***************************************************************************

  Chromaplas
  cpsttngs.h

 **************************************************************************/



#ifndef CPSTTNGS_H
#define CPSTTNGS_H


/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */

#define CPCHROMAPLASCONFIGSETTINGSNAMEBUFFERLENGTH	256	/*!< The size of the config settings name string-buffer in bytes */


/*************************
 *  Some default values  *
 *************************/

// TODO: Move these to cpsttngs.c and when serialising the config, use G_cpsDefaults


/* * Default Root settings * */
#define CPDEFAULT_SETTINGSNAME	"ChromaPlas settings generated from hardcoded default settings"


/* * Default Global settings * */

/* Speed: All the individual speeds are multiplied by this */
#define CPDEFAULT_GLOBAL_SPEED 1.0f
// Or just have an option to lock everything together? Naah! coz then undo will be harder.


/* * Default program settings * */

#ifdef CP_IS_SCREENSAVER
#define CPDEFAULT_USEIDLEPRIORITYCLASS TRUE
#else
#define CPDEFAULT_USEIDLEPRIORITYCLASS FALSE
#endif


/* * Default image settings * */

#ifdef CP_IS_SCREENSAVER
#define CPDEFAULT_IMAGESOURCE cpIMGTYPE_DESKTOP
#else
#define CPDEFAULT_IMAGESOURCE cpIMGTYPE_BUILTIN
#endif

/* Image settings: Use file as image */
#define CPDEFAULT_IMAGEFILENAME	"cp_patrn.png"	// ?: Should DOS be a 320x200 & All else be a 640x480?



/* * Default rendering settings * */

#define CPDEFAULT_IMGRESSOURCE cpIMGRESSOURCE_IMAGE

#define CPDEFAULT_IMGCUSTOMWIDTH	640
#define CPDEFAULT_IMGCUSTOMHEIGHT	480
#define CPDEFAULT_IMGCUSTOMBPP	32

#define CPDEFAULT_ZOOM TRUE
#define CPDEFAULT_ZOOM_ASPECTPRESERVE TRUE

#define CPDEFAULT_EXPANDPLASMATOFILLSCREEN	FALSE

#define CPDEFAULT_CONFINEEVERYTHINGTOSQUARE	FALSE

#define CPDEFAULT_RENDERINGTYPE cpRENDERTYPE_TRIPLE_BUFFER

#define CPDEFAULT_DISPLAYSTATS FALSE

#define CPDEFAULT_ALWAYSUSECLUTSINTCMODES	TRUE

#define CPDEFAULT_SETSOURCEBPPTO32IF24	TRUE
#define CPDEFAULT_DISABLE24BPP	FALSE
#define CPDEFAULT_DISABLE8BPP	FALSE



/* * Default plasma settings * */

/* Plasma Speed: All the individual plasma-speeds (not including the plasma-colour speeds) are multiplied by this (they still get multiplied by the global speed as well) */
#define CPDEFAULT_PLASMA_GLOBAL_SPEED 3.333333f

/* Plasma seed magnification: Acts as a multiplier for the two plasma-seeds. Units in screen-sizes. */
#define CPDEFAULT_PLASMA_GLOBAL_SEEDMAGNIFICATION 1.0f
// Or just have an option to lock everything together.

#define CPDEFAULT_PLASMA_SEED1 0.2f
#define CPDEFAULT_PLASMA_SEED2 9.5f

/* Settings for the lissajous-paramaters */
/* Note that all phase-angles are in DEGREES */

#define CPDEFAULT_PLASMA_LISSAJOUS1XAMP 1.0f
#define CPDEFAULT_PLASMA_LISSAJOUS1XFREQ 0.143239f
#define CPDEFAULT_PLASMA_LISSAJOUS1XINITPHASE 90.00000f
#define CPDEFAULT_PLASMA_LISSAJOUS1YAMP 1.0f
#define CPDEFAULT_PLASMA_LISSAJOUS1YFREQ -0.095493f
#define CPDEFAULT_PLASMA_LISSAJOUS1YINITPHASE 0.0f

#define CPDEFAULT_PLASMA_LISSAJOUS2XAMP 1.0f
#define CPDEFAULT_PLASMA_LISSAJOUS2XFREQ 0.040585f
#define CPDEFAULT_PLASMA_LISSAJOUS2XINITPHASE 0.0f
#define CPDEFAULT_PLASMA_LISSAJOUS2YAMP 1.0f
#define CPDEFAULT_PLASMA_LISSAJOUS2YFREQ -0.047746f
#define CPDEFAULT_PLASMA_LISSAJOUS2YINITPHASE 90.00000f

#define CPDEFAULT_PLASMA_LISSAJOUS3XAMP 1.0f
#define CPDEFAULT_PLASMA_LISSAJOUS3XFREQ 0.190986f
#define CPDEFAULT_PLASMA_LISSAJOUS3XINITPHASE 90.00000f
#define CPDEFAULT_PLASMA_LISSAJOUS3YAMP 1.0f
#define CPDEFAULT_PLASMA_LISSAJOUS3YFREQ -0.071620f
#define CPDEFAULT_PLASMA_LISSAJOUS3YINITPHASE 0.0f

#define CPDEFAULT_PLASMA_LISSAJOUS4XAMP 1.0f
#define CPDEFAULT_PLASMA_LISSAJOUS4XFREQ 0.167113f
#define CPDEFAULT_PLASMA_LISSAJOUS4XINITPHASE 90.00000f
#define CPDEFAULT_PLASMA_LISSAJOUS4YAMP 1.0f
#define CPDEFAULT_PLASMA_LISSAJOUS4YFREQ -0.023873f
#define CPDEFAULT_PLASMA_LISSAJOUS4YINITPHASE 0.0f

#define CPDEFAULT_PLASMA_ROLLSPEED 1.5f


#define CPDEFAULT_PLASFX_FULLINTENSITYWRAP FALSE

#define CPDEFAULT_PLASFX_INTENSITY 0x60
#define CPDEFAULT_PLASFX_INTENSITYRISETIME 0.0f

#define CPDEFAULT_PLASMA_CONFINELISSAJOUSSESTOSQUARE	FALSE


/* * Default Plasma colour settings (when no image) * */

/* Plasma Global Colour Speed: All the individual colour-speeds are multiplied by this (they still get multiplied by the global speed as well) */
#define CPDEFAULT_PLASMACOLOUR_GLOBAL_SPEED 1.0f
// Or just have an option to lock everything together.

#define CPDEFAULT_PALETTESOURCE cpPALETTESOURCE_FUNKYPALETTEEFFECT

/* Plasma colour settings: Funky palette effect */

#define CPDEFAULT_FUNKYPALETTECOLOURSPACE cpCOLOURSPACE_RGB

#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE1AMP	1.0f
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE1FREQ	0.047746f
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE1WAVENUM	1
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE1WAVEINITPHASE	120.0f

#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE2AMP	1.0f
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE2FREQ	-0.047746f
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE2WAVENUM	1
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE2WAVEINITPHASE	180.0f

#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE3AMP	1.0f
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE3FREQ	0.095493f
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE3WAVENUM	1
#define CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE3WAVEINITPHASE	240.0f

/* Plasma colour settings: External Palette */

#define CPDEFAULT_PALETTESOURCEFILENAME	"Atari8BitPalette.pcx"


/* * Default plasma effects settings (when using an image) * */

#define CPDEFAULT_PLASFX_USECOLOURSPACE cpCOLOURSPACE_HLS

#define CPDEFAULT_PLASFX_COLOURSPACE_RGB_R FALSE
#define CPDEFAULT_PLASFX_COLOURSPACE_RGB_G FALSE
#define CPDEFAULT_PLASFX_COLOURSPACE_RGB_B TRUE
#define CPDEFAULT_PLASFX_COLOURSPACE_HSV_H TRUE
#define CPDEFAULT_PLASFX_COLOURSPACE_HSV_S FALSE
#define CPDEFAULT_PLASFX_COLOURSPACE_HSV_V FALSE
#define CPDEFAULT_PLASFX_COLOURSPACE_HLS_H FALSE
#define CPDEFAULT_PLASFX_COLOURSPACE_HLS_L FALSE
#define CPDEFAULT_PLASFX_COLOURSPACE_HLS_S TRUE






/****************************************************************************
 Macros
 */


/****************************************************************************
 Global Types
 */

/* A 2D Lissajous pattern */
typedef struct CpLissajousSettingsTag
{
	/* Note that all frequencies are in CYCLES PER SECOND and initial phase-angles are in DEGREES */
	float nXAmp, nXFreq, nXInitialPhase;
	float nYAmp, nYFreq, nYInitialPhase;
}
CpLissajousSettings;

/* Describes a wave of a colour-space simulus across a colour-palette */
typedef struct CpColourspacestimulusWaveSettingsTag
{
	float nAmp;	/* Amplitude of wave relative to full wave-height */
	float nFrequency;	/* Frequency of wave in CYCLES PER SECOND. \remarks the wave-speed is the frequency divided by the wave-number. */
	int nWaveNumber;	/* Number of waves that span the range of the palette (or colour-map table). This is the reciprocal of the wavelength. Must be an integer (this ensures continuity when value wraps from 255 to 0) Can be 0 (uniform throughout the palette) or even negative (negative is equivalent to 180-nInitialPhase). */
	float nInitialPhase;	/* This is how far along the sine-wave we begin at. Angle is in DEGREES. */
}
CpColourspacestimulusWaveSettings;

typedef struct cpChromaPlasSettingsTag
{
	// Don't forget to update cpCopyCPS() and G_cpsDefaults if we update this struct.

	/* * Root settings * */
	
	char szConfigSettingsName[CPCHROMAPLASCONFIGSETTINGSNAMEBUFFERLENGTH];	/* Used to identfy the INI file that contains the settings. Can also be used to see if the INI file has loaded by going into the ABOUT dialog and seeing the name of the INI settings and comparing it with the value of this setting. */
	

	/* * Global settings * */

	float nGlobalSpeed;	/* How fast everything is going */
	// global magnification that magnifies both the seeds and the plasma-lissajous


	/* * Program Settings * */

	AeBool bUseIdlePriorityClass;	// Perhaps this could be a range of classes (idle, low, normal, high etc.), but then the ranges would have to be platform-specific


	/* * Image settings * */

	CpImageSource isImgSource;

	/* Image settings: Use file as image */
	char szFileName[CPPATHSTRINGSIZE];


	/* * Rendering settings * */
	
	CpImageResSource irsImgResSource;
	int nWidth;
	int nHeight;
	int nBPP;

	AeBool bZoom;
	AeBool bZoomAspectPreserve;
	AeBool bExpandPlasmaToFillScreen;	/* If source-image is smaller than screen, expand plasma to fill screen */
	AeBool bConfineEverythingToSquare;	/* If the screen's dimensions are not equal (usually, they aren't), confine everything to a square of the smallest screen-dimension. */

	CpRenderingType rtRenderingType;
	AeBool bDisplayStats;
	AeBool bAlwaysUseCLUTsInTruecolourModes;	/* Uses the CLUT even when we can render the raw plasma. */

	AeBool bSetSourceBPPTo32If24;	/* If the colour-depth (BPP) of the source-image is 24BPP, if set, we will attempt to set a 32bpp mode first. */
	AeBool bDisable24bpp;	/* Disables availability of 24bpp modes when attempting to set a mode. Note that bSetSourceBPPTo32If24 is assumed to be TRUE if this is set. */
	AeBool bDisable8bpp;	/* Disables availability of 24bpp modes when attempting to set a mode. Normally, we souldn't need to set this, but if running the program on Windows Vista or Windows 7, we may want to prevent the program from attempting to set 8bpp modes because Allegro has a few glitches with 8bpp modes in Windows. */


	/* * Plasma settings * */
	float nPlasmaGlobalSpeed;	/* All the individual plasma-speeds (not including the plasma-colour speeds) are multiplied by this (they still get multiplied by the global speed as well) */
	float nPlasmaGlobalSeedMultiplier;	/* Acts as a multiplier for the two plasma-seeds */
	
	float nPlasmaSeed1;
	float nPlasmaSeed2;
	CpLissajousSettings lsetPlasmaLissajousSettings[CPMAXNUMPLASMALJS];	/* This is the initial state of the lissajous settings. */

	float nPlasmaRollSpeed;

	AeBool bFullIntensityHueWrap;
	uint8_t cIntensity;
	float nIntensityRiseTime;
	AeBool bConfineLissajoussesToSquare;	/* If the plasma's dimensions are not equal (usually, they aren't), confine the loci of the lissajousses to a square of the smallest plasma-dimension. */


	/* * Plasma colour settings (when no image) * */

	float nPlasmaColourGlobalSpeed;	/* All the individual colour-animation-speeds are multiplied by this (they still get multiplied by the global speed as well) */

	CpPaletteSource psPaletteSource;	/* How the palette (CLUT) for raw plasmas will be generated. */


	/* Plasma colour settings: Funky Palette effect */

	CpColourSpace csFunkyPaletteEffectColourSpace;
	CpColourspacestimulusWaveSettings csssetColourspacestimulusWaveSettings[CPNUMSTIMULIPERCOLOURSPACE];	/* This is the initial state of the colourspace stimulus wave settings. */

	/* Plasma colour settings: External Palette */
	char szPaletteSourceFileName[CPPATHSTRINGSIZE];


	/* * Plasma effects settings (when using an image) * */

	CpColourSpace csColourSpaceToUse;
	AeBool baaColourSpaceFlags[CPNUMCOLOURSPACES][CPNUMSTIMULIPERCOLOURSPACE];

}
CpChromaPlasSettings;


/****************************************************************************
 Global Variables (across program)
 */

extern CpChromaPlasSettings G_cps;
extern AL_CONST CpChromaPlasSettings G_cpsDefaults;


/****************************************************************************
 Function Prototypes
 */


/* ChromaPlas settings functions */
void cpInitCPS(CpChromaPlasSettings *cpsp);
void cpDestroyCPS(CpChromaPlasSettings *cpsp);
void cpCopyCPS(CpChromaPlasSettings *cppDest, AL_CONST CpChromaPlasSettings *cppSource);



#endif /* CPSTTNGS_H */
