/***************************************************************************
 *
 * cpprglp.c
 * Management of the main program-loop
 *
 * By Andrei Ellman
 *
 **************************************************************************/



/****************************************************************************
 Includes
 */


#include <allegro.h>
#include <allegro/internal/aintern.h>	/* Used to get _wait_for_vsync */

#include "aeglobal.h"

#include "cpglobal.h"

#include "cpsttngs.h"

#include "cpgfx.h"
#include "cprender.h"

#include "cpplasma.h"
#include "cpfunpal.h"

#include "cpprglp.h"


/****************************************************************************
 Local Types
 */


/****************************************************************************
 Global Prototypes
 */


/****************************************************************************
 Local (Static) Prototypes
 */


/****************************************************************************
 Local Defines
 */


/****************************************************************************
 Local Macros
 */


/****************************************************************************
 Global Variables (across program)
 */



/****************************************************************************
 Local (static) Global Variables
 */





/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                          Various ancillary functions.

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */



// \sa _cpGreyOutUnusedIntensityControls()
static AeBool
_cpUseIntensityAndBounceOnPlasma(void)
{
	/* When using full intensity wrap or a CLUT, we will never bounce in the plasma.
	   Full intensity wrap by nature implies it will always be a sawtooth plasma,
	   and if applying a colour lookup table in no-image mode, the colour lookup table
	   will be responsible for the 'bounce' effect. */
	
	return (!(G_cps.bFullIntensityHueWrap || G_bApplyingColourLookupTableDirectlyToPlasmaPixels));

}



/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                              Main loop.

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */



/* Moves the plasma by the ammount it should move in numFrames frames */
// logic
void
cpDoLogic(float numFrames)
{
	float nSpeedAdjustForFramerate = ((float)CPREFERENCEREFRESHRATE)/((float)G_nRefreshRate);

	cpCalculatePlasmaParams(G_cps.nPlasmaGlobalSpeed * G_cps.nGlobalSpeed * numFrames * nSpeedAdjustForFramerate);
	if(G_cps.isImgSource == cpIMGTYPE_NONE && G_cps.psPaletteSource==cpPALETTESOURCE_FUNKYPALETTEEFFECT)
	{
		cpUpdateFunkyPaletteParams(G_cps.nPlasmaColourGlobalSpeed * G_cps.nGlobalSpeed * numFrames * nSpeedAdjustForFramerate);
	}

	cpUpdateCurrentPlasmaIntensity(numFrames);	/* As the number of ticks per intensity level has been pre-calculated, we do not need to multiply this by nSpeedAdjustForFramerate */
}



// render
static void
_cpDisplayStats(AeBool bIsInSSPreviewWindow)
{
	char szGFXCardIDString[5];	/* Gfx-mode ID-string used by chGetCurrentModeIDString() */

	// Could use if(system_driver==system_none) instead of bIsInSSPreviewWindow
	int nColourDepth = bitmap_color_depth(bIsInSSPreviewWindow?G_bmpDest:screen);
	// instead of bitmap_color_depth(G_bmpDest), could use cpDesktopColorDepth()
	int nTextColour = makecol_depth(nColourDepth, 0xFF, 0xFF, 0xFF); // Or just makecol(0xFF, 0xFF, 0xFF);
	int nBGColour = makecol_depth(nColourDepth, 0x0, 0x0, 0x0);

	int nRefreshRateColour = (G_bActualRefreshRateIsUnknown?makecol_depth(nColourDepth, 0xFF, 0x80, 0x80):nTextColour);

	AeBool *baColourSpaceFlags = G_cps.baaColourSpaceFlags[cpMapCpColourSpaceToInt(G_cps.csColourSpaceToUse)];

	int nTextY;



	nTextY=0;
	// TODO: Make text bounce


	nTextY+=16;


	textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"FPS:");

	textprintf_ex(G_bmpDest,font,56,nTextY,nTextColour, nBGColour, "%4d", G_nFps);

	textprintf_ex(G_bmpDest,font,148,nTextY,nTextColour,-1,"TT:");	// TT = Target Time
	textprintf_ex(G_bmpDest,font,180,nTextY,nTextColour,nBGColour,"%d ", G_nTargetTime);
	//textprintf_ex(G_bmpDest,font,212,nTextY,nTextColour,-1,"GT:");
	//textprintf_ex(G_bmpDest,font,244,nTextY,nTextColour,nBGColour,"%d ", G_nGameTime);

	nTextY+=16;

	textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"INI settings name: %s", G_cps.szConfigSettingsName);

	nTextY+=8;

	textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"GFX card: %s", (gfx_driver ? aeGetAllegroIDStringFromAllegroID(szGFXCardIDString,gfx_driver->id) : "[none]"));

	nTextY+=8;

	textprintf_ex(G_bmpDest,font,16,nTextY,nRefreshRateColour,-1,"%d Hz", G_nRefreshRate);

	nTextY+=8;

	textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Size: %d x %d", (bIsInSSPreviewWindow?G_bmpDest->w:SCREEN_W), (bIsInSSPreviewWindow?G_bmpDest->h:SCREEN_H));
	nTextY+=8;
	textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"BPP: %d", nColourDepth);
	nTextY+=8;
	switch(G_rtRenderingType)
	{
		case cpRENDERTYPE_STRAIGHT:
		{
			textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Straight to screen");
		}
		break;

		case cpRENDERTYPE_DOUBLE_BUFFER:
		{
			textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Double-Buffered");
		}
		break;

		case cpRENDERTYPE_PAGE_FLIP:
		{
			textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Page-flipped");
		}
		break;

		case cpRENDERTYPE_TRIPLE_BUFFER:
		{
			textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Triple-Buffered");
		}
		break;

		default:
		{
			textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Unknown rendering type");
		}
	}
	nTextY+=8;
	textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Wait for vsync: %s%s%s", (G_rtRenderingType==cpRENDERTYPE_TRIPLE_BUFFER || bIsInSSPreviewWindow?"N/A (":""), (_wait_for_vsync/*&&!*/?"ON":"OFF"), (G_rtRenderingType==cpRENDERTYPE_TRIPLE_BUFFER || bIsInSSPreviewWindow?")":""));

	nTextY+=8;

	if(G_cps.isImgSource == cpIMGTYPE_NONE)
	{
		if(bitmap_color_depth(G_bmpDest)==8)
		{
			textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Hardware CLUT");
		}
		else
		{
			if(G_bApplyingColourLookupTableDirectlyToPlasmaPixels)
			{
				textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Software CLUT");
			}
			else
			{
				textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Displaying raw plasma");
			}

		}
	}
	else
	{
		switch(G_cps.csColourSpaceToUse)
		{
			case cpCOLOURSPACE_RGB:
			{
				textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"RGB:");
			}
			break;

			case cpCOLOURSPACE_HSV:
			{
				textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"HSV:");
			}
			break;

			case cpCOLOURSPACE_HLS:
			{
				textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"HLS:");
			}
			break;

			default:
			{
				textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"???:");
			}
		}
		textprintf_ex(G_bmpDest,font,56,nTextY,nTextColour,-1,"%d %d %d", baColourSpaceFlags[0],baColourSpaceFlags[1],baColourSpaceFlags[2]);
	}

	nTextY+=8;


	if(G_cps.isImgSource == cpIMGTYPE_NONE && G_cps.psPaletteSource!=cpPALETTESOURCE_NONE)
	{
		textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Funky Palette effect or custom palette");		
	}
	else if(G_cps.bFullIntensityHueWrap)
	{
		textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Full intensity plasma wrap");		
	}
	else
	{
		if(G_cps.nIntensityRiseTime)
		{
			textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Intensity: 0x%2X ( -> 0x%2X )", cpGetCurrentPlasmaIntensity(), G_cps.cIntensity);
		}
		else
		{
			textprintf_ex(G_bmpDest,font,16,nTextY,nTextColour,-1,"Intensity: 0x%2X", cpGetCurrentPlasmaIntensity());
		}
	}



	// other stats too?

}



// render
void
cpDoRender(AeBool bIsInSSPreviewWindow)
{
	/* Pre-calculations for the render */


	/* Work out what the plasma looks like at this stage in time */
	{
		uint8_t cIntensity = cpGetCurrentPlasmaIntensity();

		cpCalculatePlasmaBody(_cpUseIntensityAndBounceOnPlasma(), cIntensity);

		/* Deal with any palette issues */
		if(G_cps.isImgSource == cpIMGTYPE_NONE)
		{
			// ?: switch() instead?
			if(G_cps.psPaletteSource==cpPALETTESOURCE_FUNKYPALETTEEFFECT)
			{
				/* Using the funky palette effect */
				cpPreCalcFunkyPalette(bitmap_color_depth(G_bmpDest));
			}
			else if(G_cps.psPaletteSource==cpPALETTESOURCE_NONE)
			{
				if(!G_cps.bFullIntensityHueWrap)
				{
					if(G_bApplyingColourLookupTableDirectlyToPlasmaPixels)
					{
						/* Every time the intensity changes, we need to calculate a new palette. */
						if(G_bIntensityHasChanged)
						{
							cpCreateMonoPaletteWithBounceAndIntensity(bitmap_color_depth(G_bmpDest), cIntensity);
							G_bIntensityHasChanged = FALSE;
						}
					}
					/* else just rely on cpCalculatePlasmaBody() to manually adjust the intensity. */
				}
			}
			/* We don't need to do owt for cpPALETTESOURCE_EXTERNALPALETTE */
		}
	}




	/* The render */


	cpRenderBegin(bIsInSSPreviewWindow);





	/* Draw the image - be it the source image combined with the plasma - or just the plasma if G_icsImgColSpc is unused */
	cpRenderScreen(G_bmpDest);


	/* Display statistics if we want to */
	if(G_cps.bDisplayStats)
	{
		_cpDisplayStats(bIsInSSPreviewWindow);
	}





	cpRenderEnd(bIsInSSPreviewWindow);

}


//   \remarks This is the app's main loop.
void
cpDoPlasma(void)
{

	AeBool bOKToDraw;


	/* Used for FPS counter */
	int nFramesDone;	/* Number of frames done in last [second]. Used for FPS counter. */

	int naFramesDrawnArray[AEGAMETIMENUMDIVISIONSPERSECOND];	/* An array to store the number of frames we did during the last CPGAMETIMENUMDIVISIONSPERSECOND 1/CPGAMETIMENUMDIVISIONSPERSECOND'ths of a second */
	int nFramesDrawnIndex;	/* used to store the index of the last updated value in the naFramesArray array */



	/******************************
	 * Set up a few things first! *
	 ******************************/


	/*
	{
		// Use to visualise the palette from cpUpdateFunkyPaletteParams()/cpPreCalcFunkyPalette() more easily (used mainly for debugging purpouses)
		int x;

		acquire_bitmap(G_bmpDest);
		for(x=0;x<256;x++)
		{
			vline(G_bmpDest,x,0,12,x);
		}
		release_bitmap(G_bmpDest);
	}
	*/







	bOKToDraw = TRUE;	// or FALSE?


	/* Reset the volatile counters */
	G_nTargetTime = 0;	/* Reset the volatile target-time (used to keep app at a constant speed) */
	G_nGameTime = 0;	/* Reset the volatile game-time (used to measure FPS) */

	/* Reset the non-volatile counter helpers */
	nFramesDone = 0;

	G_nFps=0;


	/* Reset the drawn frames array */
	for(nFramesDrawnIndex=0;nFramesDrawnIndex<AEGAMETIMENUMDIVISIONSPERSECOND;nFramesDrawnIndex++)
	{
		naFramesDrawnArray[nFramesDrawnIndex]=0;
	}
	nFramesDrawnIndex=0;




#ifdef CP_IS_SCREENSAVER
	{
		/* Reset the mouse-mickeys */
		int nDummyX, nDummyY;
		get_mouse_mickeys(&nDummyX, &nDummyY);
	}
#endif



	/*************
	 * Let's Go! *
	 *************/



	while(!cpCanExitApp())
	{

		/**************************
		 * Logic updating portion *
		 **************************/



#ifndef PROFILEMODE	/* When profiling, just do continuous logic/render cycles regardless of te tick-time */
		// NOTE: If profiling, would we have to do the version where the logic-loop is iterated per-tick instead of per G_nTargetTime
		// NOTE: Depending on whether we are using DB or PF (or TB?), we might want to move this bit elsewhere.
		while(G_nTargetTime==0)
		{
			rest(1);	/* Give Mr. CPU some rest. */
			// But this only happens if the drawing can be done in <1 frame.
			// TODO: Specfy restlength in INI file
			// ?: Does this make bOKToDraw redundant? A: We may still need bOKToDraw if this bit is if 0'd out for some reason.

			// ?: Where would be the best place to do this loop so as to work well with vsync()? Or should I consider triple-buffering?
		}
#endif


		/*
		while(G_nTargetTime>0)
		{
			cpDoLogic(1.0f);

			// We've executed the logic part of the loop one more time
			G_nTargetTime--;
			bOKToDraw = TRUE;
		}
		*/


		while(G_nTargetTime>0)
		{
			/* Using a while loop in case G_nTargetTime updates itself while we're calculating the plasma */
			int nTargetTimeAtStartOfLoop = G_nTargetTime;


			/* Update input etc. */

			if(keyboard_needs_poll())
			{
				poll_keyboard();
			}


#ifdef CP_IS_SCREENSAVER
			if(mouse_needs_poll())
			{
				poll_mouse();
			}
#endif



			cpDoLogic((float)nTargetTimeAtStartOfLoop);

			G_nTargetTime -= nTargetTimeAtStartOfLoop;
			bOKToDraw = TRUE;

			// IDEA: If this loop is iterated X times, we could escape so the framerate doesn't drop too low. But in ChromaPlas this is unlikely to happen.
		}

		
		/* Measure FPS */
		while(G_nGameTime>0)
		{
			G_nFps -= naFramesDrawnArray[nFramesDrawnIndex];	/* Decrement the FPS by the frames done the 1/CPGAMETIMENUMDIVISIONSPERSECOND'th of a second a second ago */
			naFramesDrawnArray[nFramesDrawnIndex] = nFramesDone;	/* Store the number of frames done this 1/CPGAMETIMENUMDIVISIONSPERSECOND'th second */
			G_nFps += nFramesDone;	/* Increment the fps by the newly done frames (this past 1/CPGAMETIMENUMDIVISIONSPERSECOND'th of a second) */
			
			nFramesDrawnIndex = (nFramesDrawnIndex + 1) % AEGAMETIMENUMDIVISIONSPERSECOND;	/* Increment the frame index and snap it to CPGAMETIMENUMDIVISIONSPERSECOND */
			
			G_nGameTime--;
			nFramesDone = 0;	/* Get ready for the next measurement (if we have to iterate again, the next measurement will be 0) */
		}


		/*****************************
		 * Graphics updating portion *
		 *****************************/


		if(bOKToDraw)
		{
			cpDoRender(FALSE);


			/* Draw finished */
			nFramesDone++;	/* Now we've finished the frame, increment this */
			bOKToDraw = FALSE;	/* We've just completed a draw */

//			rest(0);	/* Yield the remains of the timeslice. */
		}
#if 0
#ifndef PROFILEMODE	/* When profiling, just do continuous logic/render cycles regardless of te tick-time */
		else
		{
			rest(1);	/* Give Mr. CPU some rest. */
			// TODO: Specfy restlength in file
		}
#endif
#endif
	}

}
