/***************************************************************************

  Chromaplas
  cpglobal.h

 **************************************************************************/


#ifndef CPGLOBAL_H
#define CPGLOBAL_H


/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */


#define CPPATHSTRINGSIZE	(260+1)	/* Should be as large (or as small) as any platform-specific maximum-path (eg. MAX_PATH under Windows) plus one for terminating NULL. */ // ?: If using wide-characters, should this be *'d by 2?

#define CPMAXNUMPLASMALJS	4

#define CPNUMCOLOURSPACES	3
#define CPNUMSTIMULIPERCOLOURSPACE	3

#define CPCOLOURSPACEINDEX_NONE	-1	/* Used to tell cpGreyOutUnused() to grey out all checkboxes */
#define CPCOLOURSPACEINDEX_RGB	0
#define CPCOLOURSPACEINDEX_HSV	1
#define CPCOLOURSPACEINDEX_HLS	2

// TODO: 70 for 13h, 60 for everything else. ModeX? Perhaps create a function instead of using this macro.
#define CPREFRESHRATEVALUEWHENUNKNOWN	60	/* If the refresh rate cannot be found, we'll petend that it's this value' */

/* The speeds are standardised to the following refresh-rate. If the monitor's refresh-rate is different, then we'll use this to adjust the movement-delta to make everything move at the correct speed */
#define CPREFERENCEREFRESHRATE	60




/****************************************************************************
 Macros
 */


#define safefree(x)	\
	if(x)	\
	{	\
		free(x);	\
		x=NULL;		\
	}


/****************************************************************************
 Global Types
 */

// ?: -> cpsttngs?


typedef enum
{
	cpRENDERTYPE_ERROR,		/* Invalid rendering-type */
	cpRENDERTYPE_STRAIGHT,		/* Render straight to the screen (not recommended) */
	cpRENDERTYPE_DOUBLE_BUFFER,	/* Render to an offscreen memory buffer and copy it to the screen. Note that if not rendering to an Allegro graphics mode, this is what will be used. */
	cpRENDERTYPE_PAGE_FLIP,		/* Render to a second screen and then display that screen */
	cpRENDERTYPE_TRIPLE_BUFFER	/* Render to a second screen and then display that screen */
}
CpRenderingType;

typedef enum 
{
	cpIMGTYPE_ERROR,	/* Invalid image source */
	cpIMGTYPE_NONE,		/* No image is being used - just use the plasma */
	cpIMGTYPE_BUILTIN,	/* Use the builtin image (an image generated by the program) */
	cpIMGTYPE_DESKTOP,	/* Use the desktop as the image */
	cpIMGTYPE_DESKTOP_WALLPAPER,	/* Use the desktop wallpaper as the image */
	cpIMGTYPE_FILE	/* Load the image from the file */
}
CpImageSource;

typedef enum 
{
	cpIMGRESSOURCE_ERROR,	/* Invalid image resolution source */
	cpIMGRESSOURCE_IMAGE,	/* Obtain image resolution from image or desktop */
	cpIMGRESSOURCE_CUSTOM	/* Use the custom image resolution that we have specified */
}
CpImageResSource;

typedef enum
{
	cpCOLOURSPACE_ERROR,	/* Invalid colour-space */
	cpCOLOURSPACE_RGB,	/* RGB colour-space */
	cpCOLOURSPACE_HSV,	/* HSV colour-space */
	cpCOLOURSPACE_HLS	/* HLS colour-space */
}
CpColourSpace;


typedef enum
{
	cpPALETTESOURCE_ERROR,	/* Invalid palette-source */
	cpPALETTESOURCE_NONE,	/* Use a simple generated palette (eg. index maps to brightness). */
	cpPALETTESOURCE_FUNKYPALETTEEFFECT,	/* Use the funky palette effect */
	cpPALETTESOURCE_EXTERNALPALETTE	/* Load the palette from an external source (eg. an image or palette file) */
}
CpPaletteSource;



/****************************************************************************
 Global Variables (across program)
 */

// ?: -> cpprglp ?

extern volatile int G_nTargetTime;
extern volatile int G_nGameTime;

extern int G_nFps;


/****************************************************************************
 Function Prototypes
 */


/* Interupt stuff */
void cpResetGlobalExitFlag(void);

#ifdef CP_IS_SCREENSAVER
void cpResetAppInForegroundFlag(void);
#endif

AeBool cpStartTimers(int nRefreshRate);
void cpStopTimers(void);


/* Various ancillary functions */
AL_CONST char * aeGetAllegroIDStringFromAllegroID(char *szModeIDString, int nID);
AeBool cpCanExitApp(void);

/* Setup/cleanup */
AeBool cpSetupChromaPlasProgramInitAllegro(AeBool bUseSystemDriver, AeBool bLoadAllegroSettings, AeBool bLoadAppSettings);
void cpCleanupChromaPlasProgramTiniAllegro(void);

AeBool cpInitChromaPlas(AeBool bSetGfxMode, int nDestWidth, int nDestHeight, int nDestBPP);
void cpTiniChromaPlas(AeBool bSetGfxMode);

/* The program */
int cpDoProgram(AeBool bAllegroPreviouslyInitialised, AeBool bLoadAllegroSettings, AeBool bLoadAppSettings);


#endif /* CPGLOBAL_H */
