/***************************************************************************
 *
 * cpsttngs.c
 * Management of the chromaplas settings
 *
 * As well as defining the setting datastructures and the global settings variable, also defines some validators.
 *
 * By Andrei Ellman
 *
 **************************************************************************/



/****************************************************************************
 Includes
 */


#include <allegro.h>

#include "aeglobal.h"

#include "cpglobal.h"

#include "cpmthhlp.h"	// for pi

#include "cpsttngs.h"


/****************************************************************************
 Local Types
 */


/****************************************************************************
 Global Prototypes
 */


/****************************************************************************
 Local (Static) Prototypes
 */


/****************************************************************************
 Local Defines
 */


/****************************************************************************
 Local Macros
 */


/****************************************************************************
 Global Variables (across program)
 */

CpChromaPlasSettings G_cps;	/* The current program settings */

/* The default ChromaPlas settings */
AL_CONST CpChromaPlasSettings G_cpsDefaults = 
{
	/* * Default Root settings * */

	CPDEFAULT_SETTINGSNAME,


	/* * Default Global settings * */
	
	CPDEFAULT_GLOBAL_SPEED,
	

	/* * Default program settings * */

	CPDEFAULT_USEIDLEPRIORITYCLASS,


	/* * Default image settings * */

	CPDEFAULT_IMAGESOURCE,

	/* Image settings: Use file as image */
	CPDEFAULT_IMAGEFILENAME,	// ?: Does this need to be copied?


	/* * Default rendering settings * */

	CPDEFAULT_IMGRESSOURCE,

	CPDEFAULT_IMGCUSTOMWIDTH,
	CPDEFAULT_IMGCUSTOMHEIGHT,
	CPDEFAULT_IMGCUSTOMBPP,

	CPDEFAULT_ZOOM,
	CPDEFAULT_ZOOM_ASPECTPRESERVE,

	CPDEFAULT_EXPANDPLASMATOFILLSCREEN,

	CPDEFAULT_CONFINEEVERYTHINGTOSQUARE,

	CPDEFAULT_RENDERINGTYPE,

	CPDEFAULT_DISPLAYSTATS,
	
	CPDEFAULT_ALWAYSUSECLUTSINTCMODES,

	CPDEFAULT_SETSOURCEBPPTO32IF24,
	CPDEFAULT_DISABLE24BPP,
	CPDEFAULT_DISABLE8BPP,


	/* * Default plasma settings * */

	CPDEFAULT_PLASMA_GLOBAL_SPEED,
	CPDEFAULT_PLASMA_GLOBAL_SEEDMAGNIFICATION,

	CPDEFAULT_PLASMA_SEED1,
	CPDEFAULT_PLASMA_SEED2,

	{
		{
			CPDEFAULT_PLASMA_LISSAJOUS1XAMP,
			CPDEFAULT_PLASMA_LISSAJOUS1XFREQ,
			CPDEFAULT_PLASMA_LISSAJOUS1XINITPHASE,

			CPDEFAULT_PLASMA_LISSAJOUS1YAMP,
			CPDEFAULT_PLASMA_LISSAJOUS1YFREQ,
			CPDEFAULT_PLASMA_LISSAJOUS1YINITPHASE
		},

		{
			CPDEFAULT_PLASMA_LISSAJOUS2XAMP,
			CPDEFAULT_PLASMA_LISSAJOUS2XFREQ,
			CPDEFAULT_PLASMA_LISSAJOUS2XINITPHASE,

			CPDEFAULT_PLASMA_LISSAJOUS2YAMP,
			CPDEFAULT_PLASMA_LISSAJOUS2YFREQ,
			CPDEFAULT_PLASMA_LISSAJOUS2YINITPHASE
		},

		{
			CPDEFAULT_PLASMA_LISSAJOUS3XAMP,
			CPDEFAULT_PLASMA_LISSAJOUS3XFREQ,
			CPDEFAULT_PLASMA_LISSAJOUS3XINITPHASE,

			CPDEFAULT_PLASMA_LISSAJOUS3YAMP,
			CPDEFAULT_PLASMA_LISSAJOUS3YFREQ,
			CPDEFAULT_PLASMA_LISSAJOUS3YINITPHASE
		},

		{
			CPDEFAULT_PLASMA_LISSAJOUS4XAMP,
			CPDEFAULT_PLASMA_LISSAJOUS4XFREQ,
			CPDEFAULT_PLASMA_LISSAJOUS4XINITPHASE,

			CPDEFAULT_PLASMA_LISSAJOUS4YAMP,
			CPDEFAULT_PLASMA_LISSAJOUS4YFREQ,
			CPDEFAULT_PLASMA_LISSAJOUS4YINITPHASE
		}
	},

	CPDEFAULT_PLASMA_ROLLSPEED,

	CPDEFAULT_PLASFX_FULLINTENSITYWRAP,

	CPDEFAULT_PLASFX_INTENSITY,
	CPDEFAULT_PLASFX_INTENSITYRISETIME,
	
	CPDEFAULT_PLASMA_CONFINELISSAJOUSSESTOSQUARE,


	/* * Default plasma colour settings (when no image) * */

	CPDEFAULT_PLASMACOLOUR_GLOBAL_SPEED,

	CPDEFAULT_PALETTESOURCE,

	/* Plasma colour settings: Funky palette effect */
	CPDEFAULT_FUNKYPALETTECOLOURSPACE,

	{
		{
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE1AMP,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE1FREQ,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE1WAVENUM,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE1WAVEINITPHASE
		},

		{
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE2AMP,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE2FREQ,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE2WAVENUM,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE2WAVEINITPHASE
		},

		{
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE3AMP,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE3FREQ,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE3WAVENUM,
			CPDEFAULT_PLASMACOLOUR_COLOURSPACESTIMULUSWAVE3WAVEINITPHASE
		}
	},

	/* Plasma colour settings: External Palette */
	CPDEFAULT_PALETTESOURCEFILENAME,	// ?: Does this need to be copied?


	/* * Default plasma effects settings (when using an image) * */

	CPDEFAULT_PLASFX_USECOLOURSPACE,

	{
		{
			CPDEFAULT_PLASFX_COLOURSPACE_RGB_R,
			CPDEFAULT_PLASFX_COLOURSPACE_RGB_G,
			CPDEFAULT_PLASFX_COLOURSPACE_RGB_B
		},
		{
			CPDEFAULT_PLASFX_COLOURSPACE_HSV_H,
			CPDEFAULT_PLASFX_COLOURSPACE_HSV_S,
			CPDEFAULT_PLASFX_COLOURSPACE_HSV_V
		},
		{
			CPDEFAULT_PLASFX_COLOURSPACE_HLS_H,
			CPDEFAULT_PLASFX_COLOURSPACE_HLS_L,
			CPDEFAULT_PLASFX_COLOURSPACE_HLS_S
		}
	},

};


/****************************************************************************
 Local (static) Global Variables
 */



/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                       ChromaPlas settings functions.

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */



/* Initialise a CpChromaPlasSettings */
void cpInitCPS(CpChromaPlasSettings *cpsp)
{
	/* Empty various strings */

	ustrzcpy(cpsp->szConfigSettingsName, CPCHROMAPLASCONFIGSETTINGSNAMEBUFFERLENGTH, empty_string);

	ustrzcpy(cpsp->szFileName, CPPATHSTRINGSIZE, empty_string);
	ustrzcpy(cpsp->szPaletteSourceFileName, CPPATHSTRINGSIZE, empty_string);
}

/* Destroy a CpChromaPlasSettings */
void cpDestroyCPS(CpChromaPlasSettings *cpsp)
{
}



/* Make a copy of a CpChromaPlasSettings struct */
void
cpCopyCPS(CpChromaPlasSettings *cppDest, AL_CONST CpChromaPlasSettings *cppSource)
{
	unsigned int nI, nJ;

	/* * Root settings * */
	ustrzcpy(cppDest->szConfigSettingsName, CPCHROMAPLASCONFIGSETTINGSNAMEBUFFERLENGTH, cppSource->szConfigSettingsName);

	/* * Global settings * */
	cppDest->nGlobalSpeed = cppSource->nGlobalSpeed;

	/* * Program settings * */
	cppDest->bUseIdlePriorityClass = cppSource->bUseIdlePriorityClass;

	/* * Image settings * */
	cppDest->isImgSource = cppSource->isImgSource;
	/* Image settings: Use file as image */
	ustrzcpy(cppDest->szFileName, CPPATHSTRINGSIZE, cppSource->szFileName);

	/* * Rendering settings * */
	cppDest->irsImgResSource = cppSource->irsImgResSource;
	cppDest->nWidth = cppSource->nWidth;
	cppDest->nHeight = cppSource->nHeight;
	cppDest->nBPP = cppSource->nBPP;

	cppDest->bZoom = cppSource->bZoom;
	cppDest->bZoomAspectPreserve = cppSource->bZoomAspectPreserve;
	cppDest->bExpandPlasmaToFillScreen = cppSource->bExpandPlasmaToFillScreen;
	cppDest->bConfineEverythingToSquare = cppSource->bConfineEverythingToSquare;

	cppDest->rtRenderingType = cppSource->rtRenderingType;
	cppDest->bDisplayStats = cppSource->bDisplayStats;
	cppDest->bAlwaysUseCLUTsInTruecolourModes = cppSource->bAlwaysUseCLUTsInTruecolourModes;

	cppDest->bSetSourceBPPTo32If24 = cppSource->bSetSourceBPPTo32If24;
	cppDest->bDisable24bpp = cppSource->bDisable24bpp;
	cppDest->bDisable8bpp = cppSource->bDisable8bpp;

	/* * Plasma settings * */
	cppDest->nPlasmaGlobalSpeed = cppSource->nPlasmaGlobalSpeed;
	cppDest->nPlasmaGlobalSeedMultiplier = cppSource->nPlasmaGlobalSeedMultiplier;

	cppDest->nPlasmaSeed1 = cppSource->nPlasmaSeed1;
	cppDest->nPlasmaSeed2 = cppSource->nPlasmaSeed2;
	for(nI=0;nI<CPMAXNUMPLASMALJS;nI++)
	{
		cppDest->lsetPlasmaLissajousSettings[nI].nXAmp = cppSource->lsetPlasmaLissajousSettings[nI].nXAmp;
		cppDest->lsetPlasmaLissajousSettings[nI].nYAmp = cppSource->lsetPlasmaLissajousSettings[nI].nYAmp;
		cppDest->lsetPlasmaLissajousSettings[nI].nXFreq = cppSource->lsetPlasmaLissajousSettings[nI].nXFreq;
		cppDest->lsetPlasmaLissajousSettings[nI].nYFreq = cppSource->lsetPlasmaLissajousSettings[nI].nYFreq;
		cppDest->lsetPlasmaLissajousSettings[nI].nXInitialPhase = cppSource->lsetPlasmaLissajousSettings[nI].nXInitialPhase;
		cppDest->lsetPlasmaLissajousSettings[nI].nYInitialPhase = cppSource->lsetPlasmaLissajousSettings[nI].nYInitialPhase;
	}

	cppDest->nPlasmaRollSpeed = cppSource->nPlasmaRollSpeed;

	cppDest->bFullIntensityHueWrap = cppSource->bFullIntensityHueWrap;
	cppDest->cIntensity = cppSource->cIntensity;
	cppDest->nIntensityRiseTime = cppSource->nIntensityRiseTime;
	cppDest->bConfineLissajoussesToSquare = cppSource->bConfineLissajoussesToSquare;

	/* * Plasma colour settings (when no image) * */
	cppDest->nPlasmaColourGlobalSpeed = cppSource->nPlasmaColourGlobalSpeed;

	cppDest->psPaletteSource = cppSource->psPaletteSource;
	/* Plasma colour settings: Funky Palette effect */
	cppDest->csFunkyPaletteEffectColourSpace = cppSource->csFunkyPaletteEffectColourSpace;
	for(nI=0;nI<CPNUMSTIMULIPERCOLOURSPACE;nI++)
	{
		cppDest->csssetColourspacestimulusWaveSettings[nI].nAmp = cppSource->csssetColourspacestimulusWaveSettings[nI].nAmp;
		cppDest->csssetColourspacestimulusWaveSettings[nI].nFrequency = cppSource->csssetColourspacestimulusWaveSettings[nI].nFrequency;
		cppDest->csssetColourspacestimulusWaveSettings[nI].nWaveNumber = cppSource->csssetColourspacestimulusWaveSettings[nI].nWaveNumber;
		cppDest->csssetColourspacestimulusWaveSettings[nI].nInitialPhase = cppSource->csssetColourspacestimulusWaveSettings[nI].nInitialPhase;
	}
	/* Plasma colour settings: External Palette */
	ustrzcpy(cppDest->szPaletteSourceFileName, CPPATHSTRINGSIZE, cppSource->szPaletteSourceFileName);

	/* * Plasma effects settings (when using an image) * */
	cppDest->csColourSpaceToUse = cppSource->csColourSpaceToUse;
	for(nJ=0;nJ<CPNUMCOLOURSPACES;nJ++)
	{
		for(nI=0;nI<CPNUMSTIMULIPERCOLOURSPACE;nI++)
		{
			cppDest->baaColourSpaceFlags[nJ][nI] = cppSource->baaColourSpaceFlags[nJ][nI];
		}
	}
}


// TODO: Add some validators

