/***************************************************************************

  Chromaplas
  cpmthhlp.h

 **************************************************************************/



#ifndef CPMTHHLP_H
#define CPMTHHLP_H


/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */

#define pi 3.1415926535897932384626433832795

#define CPMULTTABSIZE 65536

//#define CPSWITCH_USE_MULT_TABLE	/*!< If defined, this will use a pre-calculatedn table to multiply 0.8 fixed-point numbers. Otherwise, regular multiplication will be used. */

/****************************************************************************
 Macros
 */


#ifdef CPSWITCH_USE_MULT_TABLE

/* Lookup table mul only works on 0.8 fixed-point unsigned numbers. 00 is considered 0.0, FF is considered 1.0 */
// ?: Turn into an inline function so we don't have to expose G_caMultTab? 
#define cpMUL8(a,b) (G_caMultTab[((a)<<8)+(b)])	/* Fixed-point multiplication for 0.8 fixed-point numbers. This implementation uses a 65535-entry lookup-table for numbers in the range 0.0-1.0 */
/* The regular fixed-mul may sometimes be faster than lookup table mul, but it's less accurate: FF*FF = FE01 */

#else

#define cpMUL8(a,b) (((a)*(b))>>8)	/* Fixed-point multiplication for 0.8 fixed-point numbers. This implementation uses regular multiplication on the two numbers and right-shifts the result so it's in 0.8 format. */
/* Regular fixed-point multiplication for 0.8 fixed numbers is actually faster on most modern machines */

#endif


#define CPRAD2DEG(x)	((x)*57.295779513082320876798154814105f)	/* x * (360/2pi) */
#define CPDEG2RAD(x)	((x)*0.017453292519943295769236907684886f)	/* x * (2pi/360) */
#define CPRAD205FF(x)	((x)*244.30283764605934040523657677681f)	/* x * (0x5FF/2pi) */



/****************************************************************************
 Global Types
 */


/****************************************************************************
 Global Variables (across program)
 */

#ifdef CPSWITCH_USE_MULT_TABLE

extern uint8_t G_caMultTab[CPMULTTABSIZE];

#endif


/****************************************************************************
 Function Prototypes
 */

void cpPreCalcMultTab(void);

void cpSetupPreCalcs(void);
void cpCleanUpPreCalcs(void);


#endif /* CPMTHHLP_H */
