/***************************************************************************
 *
 * cpmthhlp.c
 * ChromaPlas mathematical helpers
 * Mainly used for setting up and doing maths involving pre-calculated tables.
 *
 * By Andrei Ellman
 *
 **************************************************************************/



/****************************************************************************
 Includes
 */


#include <allegro.h>	// Needed for the std int types

#include "aeglobal.h"	// Needed for chglobal
#include "cpglobal.h"	// ?: Needed?

#include "cpmthhlp.h"


/****************************************************************************
 Local Types
 */


/****************************************************************************
 Global Prototypes
 */


/****************************************************************************
 Local (Static) Prototypes
 */


/****************************************************************************
 Local Defines
 */


/****************************************************************************
 Local Macros
 */


/****************************************************************************
 Global Variables (across program)
 */


#ifdef CPSWITCH_USE_MULT_TABLE

uint8_t G_caMultTab[CPMULTTABSIZE];	// Pre-calculated multiplies for numbers between 0 and 1.

#endif


/****************************************************************************
 Local (static) Global Variables
 */




/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                                  Pre-calcs

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */



#ifdef CPSWITCH_USE_MULT_TABLE

/* If using a table to do 0.8 fixed-point multiplication, calculate it here. */
void
cpPreCalcMultTab(void)
{
	int x,y;


	// Shortcut: as x*y=y*x, we could create a function that looks up the answer by multiplying MIN with MAX, but that would add overhead to the calculation.
	
	/* (a*b) * 256.0 where a and b range from 0-1 (00-FF). FF is considered 1.0 */

	for(y=0;y<256;y++)
	{
		for(x=0;x<256;x++)
		{
			float nTemp = ((y/255.0f) * (x/255.0f)) * 255.0f;	// ?: should we * by 255 and not bother with the 1.00->ff bit?
			G_caMultTab[(y<<8)+x] = (uint8_t)(nTemp + 0.5); /* +0.5f added because the cast rounds by ignoring the fractional part. */
		}
	}
}

#endif



/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                                  Setup

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */


void
cpSetupPreCalcs(void)
{

#ifdef CPSWITCH_USE_MULT_TABLE

	cpPreCalcMultTab();

#endif

	// ... and set up any other tabs we care to setup
}

void
cpCleanUpPreCalcs(void)
{
	// Needed?
}
